/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trackingsvn;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.JobProperty;
import hudson.plugins.trackingsvn.TrackingSVNProperty;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingSVNProperty
extends JobProperty<AbstractProject<?, ?>> {
    private final String sourceProject;
    private final ToTrack toTrack;

    @DataBoundConstructor
    public TrackingSVNProperty(String sourceProject, ToTrack toTrack) {
        this.sourceProject = Util.fixEmptyAndTrim((String)sourceProject);
        this.toTrack = toTrack;
        if (sourceProject == null) {
            throw new NullPointerException("'project to track' is required");
        }
        if (Hudson.getInstance().getItem(sourceProject) == null) {
            throw new IllegalArgumentException("Project to track unknown: " + sourceProject);
        }
    }

    public String getSourceProject() {
        return this.sourceProject;
    }

    public ToTrack getToTrack() {
        return this.toTrack;
    }
}

