/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trackingsvn;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Hudson;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.Run;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class TrackingSVNAction
extends InvisibleAction
implements EnvironmentContributingAction {
    private final String trackedBuildProject;
    private final int trackedBuildNumber;

    public TrackingSVNAction(Run<?, ?> build) {
        this.trackedBuildProject = build.getParent().getName();
        this.trackedBuildNumber = build.getNumber();
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        env.put((Object)"TRACKING_SVN_BUILD", (Object)this.getTrackedBuildURL());
    }

    public Run<?, ?> getTrackedBuild() {
        Job job = (Job)Hudson.getInstance().getItem(this.trackedBuildProject);
        return job.getBuildByNumber(this.trackedBuildNumber);
    }

    @Exported(visibility=2)
    public String getTrackedBuildProject() {
        return this.trackedBuildProject;
    }

    @Exported(visibility=2)
    public int getTrackedBuildNumber() {
        return this.trackedBuildNumber;
    }

    @Exported(visibility=2)
    public String getTrackedBuildURL() {
        Run<?, ?> r = this.getTrackedBuild();
        if (r == null) {
            return null;
        }
        return Hudson.getInstance().getRootUrl() + r.getUrl();
    }
}

