/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trackingsvn;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.scm.SubversionSCM;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingSVNProperty
extends JobProperty<AbstractProject<?, ?>> {
    private final String sourceProject;
    private final ToTrack toTrack;

    @DataBoundConstructor
    public TrackingSVNProperty(String sourceProject, ToTrack toTrack) {
        this.sourceProject = Util.fixEmptyAndTrim((String)sourceProject);
        this.toTrack = toTrack;
        if (sourceProject == null) {
            throw new NullPointerException("'project to track' is required");
        }
        if (Hudson.getInstance().getItem(sourceProject) == null) {
            throw new IllegalArgumentException("Project to track unknown: " + sourceProject);
        }
    }

    public String getSourceProject() {
        return this.sourceProject;
    }

    public ToTrack getToTrack() {
        return this.toTrack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return Job.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Track another SVN project";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.getJSONObject("track-svn") == null || formData.getJSONObject("track-svn").isNullObject()) {
                return null;
            }
            return super.newInstance(req, formData.getJSONObject("track-svn"));
        }

        public FormValidation doCheckSourceProject(@AncestorInPath AccessControlled subject, @QueryParameter String value) {
            if (!subject.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null) {
                return FormValidation.ok();
            }
            if ((value = value.trim()).equals("")) {
                return FormValidation.error((String)"This field is required");
            }
            TopLevelItem item = Hudson.getInstance().getItem(value);
            if (item == null) {
                return FormValidation.error((String)("No such project '" + value + "'. Did you mean '" + AbstractProject.findNearest((String)value).getName() + "' ?"));
            }
            if (item instanceof Job && ((AbstractProject)item).getScm() instanceof SubversionSCM) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("'" + value + "' is not an SVN project"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToTrack {
        LAST_STABLE("Last stable build"){

            @Override
            public Run<?, ?> getBuild(Job<?, ?> project) {
                return project.getLastStableBuild();
            }
        }
        ,
        LAST_SUCCESSFUL("Last successful build"){

            @Override
            public Run<?, ?> getBuild(Job<?, ?> project) {
                return project.getLastSuccessfulBuild();
            }
        }
        ,
        LAST_BUILD("Last build"){

            @Override
            public Run<?, ?> getBuild(Job<?, ?> project) {
                return project.getLastCompletedBuild();
            }
        }
        ,
        LAST_FAILED_BUILD("Last failed build"){

            @Override
            public Run<?, ?> getBuild(Job<?, ?> project) {
                return project.getLastFailedBuild();
            }
        };

        private String displayValue;

        private ToTrack(String displayValue) {
            this.displayValue = displayValue;
        }

        public abstract Run<?, ?> getBuild(Job<?, ?> var1);

        public String toString() {
            return this.displayValue;
        }
    }
}

