/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trackingsvn;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.trackingsvn.TrackingSVNAction;
import hudson.plugins.trackingsvn.TrackingSVNException;
import hudson.plugins.trackingsvn.TrackingSVNProperty;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SubversionTagAction;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingSVNRunListener
extends RunListener<AbstractBuild> {
    public TrackingSVNRunListener() {
        super(AbstractBuild.class);
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
        TrackingSVNProperty property = (TrackingSVNProperty)r.getProject().getProperty(TrackingSVNProperty.class);
        if (property == null) {
            return;
        }
        listener.getLogger().println("Tracking SVN of " + r.getDisplayName());
        String sourceProject = property.getSourceProject();
        TrackingSVNProperty.ToTrack toTrack = property.getToTrack();
        Job job = (Job)Hudson.getInstance().getItem(sourceProject);
        if (job == null) {
            throw new TrackingSVNException("Unknown source project for tracking-svn : " + sourceProject);
        }
        Run<?, ?> run = toTrack.getBuild(job);
        if (run == null) {
            throw new TrackingSVNException((Object)((Object)toTrack) + " not found for project " + sourceProject);
        }
        SubversionTagAction tagAction = (SubversionTagAction)run.getAction(SubversionTagAction.class);
        if (tagAction == null) {
            throw new TrackingSVNException("Project " + sourceProject + " is not an SVN project");
        }
        ArrayList revisions = new ArrayList(tagAction.getTags().keySet());
        RevisionParameterAction action = new RevisionParameterAction(revisions);
        r.addAction((Action)action);
        r.addAction((Action)new TrackingSVNAction((Run<?, ?>)r));
    }
}

