/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trackingsvn;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Run;
import hudson.plugins.trackingsvn.TrackingSVNException;
import hudson.plugins.trackingsvn.TrackingSVNProperty;
import java.util.Collection;
import java.util.Collections;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingSVNProperty
extends JobProperty<AbstractProject<?, ?>> {
    private final String sourceProject;
    private final ToTrack toTrack;
    private final String ignoredURLs;

    @DataBoundConstructor
    public TrackingSVNProperty(String sourceProject, ToTrack toTrack, String ignoredURLs) {
        this.ignoredURLs = ignoredURLs;
        this.sourceProject = Util.fixEmptyAndTrim((String)sourceProject);
        this.toTrack = toTrack;
        if (sourceProject == null) {
            throw new NullPointerException("'project to track' is required");
        }
        if (Hudson.getInstance().getItem(sourceProject) == null) {
            throw new IllegalArgumentException("Project to track unknown: " + sourceProject);
        }
    }

    public String getSourceProject() {
        return this.sourceProject;
    }

    public ToTrack getToTrack() {
        return this.toTrack;
    }

    public boolean isURLIgnored(String url) {
        if (this.ignoredURLs == null) {
            return false;
        }
        for (String s : this.ignoredURLs.split("[, \n]")) {
            if (!url.equals(Util.fixEmptyAndTrim((String)s))) continue;
            return true;
        }
        return false;
    }

    public Run getTrackedBuild() throws TrackingSVNException {
        Job job = (Job)Hudson.getInstance().getItem(this.sourceProject);
        if (job == null) {
            throw new TrackingSVNException("Unknown source project for tracking-svn : " + this.sourceProject);
        }
        Run run = this.toTrack.getBuild(job);
        if (run == null) {
            throw new TrackingSVNException(this.toTrack + " not found for project " + this.sourceProject);
        }
        return run;
    }

    public Collection<Action> getJobActions(AbstractProject<?, ?> job) {
        return Collections.singleton(new TrackingSVNJobAction(this));
    }

    public String getIgnoredURLs() {
        return this.ignoredURLs;
    }
}

