/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trackingsvn;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.trackingsvn.TrackingSVNAction;
import hudson.plugins.trackingsvn.TrackingSVNException;
import hudson.plugins.trackingsvn.TrackingSVNProperty;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SubversionSCM;
import hudson.scm.SubversionTagAction;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class TrackingSVNRunListener
extends RunListener<AbstractBuild> {
    public TrackingSVNRunListener() {
        super(AbstractBuild.class);
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
        TrackingSVNProperty property = (TrackingSVNProperty)r.getProject().getProperty(TrackingSVNProperty.class);
        if (property == null) {
            return;
        }
        Run run = property.getTrackedBuild();
        listener.getLogger().println("Tracking SVN of " + run.getFullDisplayName());
        SubversionTagAction tagAction = (SubversionTagAction)run.getAction(SubversionTagAction.class);
        if (tagAction == null) {
            throw new TrackingSVNException("Project " + property.getSourceProject() + " is not an SVN project");
        }
        ArrayList<SubversionSCM.SvnInfo> revisions = new ArrayList<SubversionSCM.SvnInfo>();
        for (SubversionSCM.SvnInfo info : tagAction.getTags().keySet()) {
            if (property.isURLIgnored(info.url)) continue;
            revisions.add(info);
        }
        RevisionParameterAction action = new RevisionParameterAction(revisions);
        r.addAction((Action)action);
        r.addAction((Action)new TrackingSVNAction(run));
    }
}

