/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.tusarnotifier;

import com.thalesgroup.dtkit.metrics.hudson.api.type.CoverageType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MeasureType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.ViolationsType;
import com.thalesgroup.hudson.plugins.tusarnotifier.TusarTransformer;
import com.thalesgroup.hudson.plugins.tusarnotifier.util.TusarNotifierLogger;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TusarNotifier
extends Notifier {
    private TestType[] tests;
    private CoverageType[] coverages;
    private ViolationsType[] violations;
    private MeasureType[] measures;

    public TusarNotifier(TestType[] tests, CoverageType[] coverages, ViolationsType[] violations, MeasureType[] measures) {
        this.tests = tests;
        this.coverages = coverages;
        this.violations = violations;
        this.measures = measures;
    }

    public TestType[] getTests() {
        return this.tests;
    }

    public CoverageType[] getCoverages() {
        return this.coverages;
    }

    public ViolationsType[] getViolations() {
        return this.violations;
    }

    public MeasureType[] getMeasures() {
        return this.measures;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        TusarNotifierLogger.log((TaskListener)listener, (String)"Starting processing all analysis reports.");
        TusarTransformer tusarTransformer = new TusarTransformer(launcher.getListener(), this.tests, this.coverages, this.violations, this.measures);
        String result = (String)build.getWorkspace().act((FilePath.FileCallable)tusarTransformer);
        if (result == null) {
            build.setResult(Result.FAILURE);
            TusarNotifierLogger.log((TaskListener)listener, (String)"Stopping TUSARNOFIFIER.");
            return true;
        }
        ArrayList<StringParameterValue> parameterValues = new ArrayList<StringParameterValue>();
        parameterValues.add(new StringParameterValue("sonar.language", "tusar"));
        parameterValues.add(new StringParameterValue("sonar.tusar.reportsPaths", result));
        build.addAction((Action)new ParametersAction(parameterValues));
        return true;
    }
}

