/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.tusarnotifier;

import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.CoverageTypeDescriptor;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.MeasureTypeDescriptor;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.TestTypeDescriptor;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.ViolationsTypeDescriptor;
import com.thalesgroup.dtkit.metrics.hudson.api.type.CoverageType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MeasureType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.ViolationsType;
import com.thalesgroup.hudson.plugins.tusarnotifier.TusarTransformer;
import com.thalesgroup.hudson.plugins.tusarnotifier.util.TusarNotifierLogger;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TusarNotifier
extends Notifier {
    private TestType[] tests;
    private CoverageType[] coverages;
    private ViolationsType[] violations;
    private MeasureType[] measures;

    public TusarNotifier(TestType[] tests, CoverageType[] coverages, ViolationsType[] violations, MeasureType[] measures) {
        this.tests = tests;
        this.coverages = coverages;
        this.violations = violations;
        this.measures = measures;
    }

    public TestType[] getTests() {
        return this.tests;
    }

    public CoverageType[] getCoverages() {
        return this.coverages;
    }

    public ViolationsType[] getViolations() {
        return this.violations;
    }

    public MeasureType[] getMeasures() {
        return this.measures;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        TusarNotifierLogger.log((TaskListener)listener, "Starting processing all analysis reports.");
        TusarTransformer tusarTransformer = new TusarTransformer(launcher.getListener(), this.tests, this.coverages, this.violations, this.measures);
        String result = (String)build.getWorkspace().act((FilePath.FileCallable)tusarTransformer);
        if (result == null) {
            build.setResult(Result.FAILURE);
            TusarNotifierLogger.log((TaskListener)listener, "Stopping TUSARNOFIFIER.");
            return true;
        }
        ArrayList<StringParameterValue> parameterValues = new ArrayList<StringParameterValue>();
        parameterValues.add(new StringParameterValue("sonar.language", "tusar"));
        parameterValues.add(new StringParameterValue("sonar.tusar.reportsPaths", result));
        build.addAction((Action)new ParametersAction(parameterValues));
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=1.0)
    public static final class TusarNotifierDescriptor
    extends BuildStepDescriptor<Publisher> {
        public TusarNotifierDescriptor() {
            super(TusarNotifier.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/tusarnotifier/help.html";
        }

        public String getDisplayName() {
            return "TUSAR Notifier";
        }

        public DescriptorExtensionList<TestType, TestTypeDescriptor<?>> getListTestDescriptors() {
            return TestTypeDescriptor.all();
        }

        public DescriptorExtensionList<ViolationsType, ViolationsTypeDescriptor<?>> getListViolationDescriptors() {
            return ViolationsTypeDescriptor.all();
        }

        public DescriptorExtensionList<MeasureType, MeasureTypeDescriptor<?>> getListMeasureDescriptors() {
            return MeasureTypeDescriptor.all();
        }

        public DescriptorExtensionList<CoverageType, CoverageTypeDescriptor<?>> getListCoverageDescriptors() {
            return CoverageTypeDescriptor.all();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List tests = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"tests", this.getListTestDescriptors());
            List coverages = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"coverages", this.getListCoverageDescriptors());
            List violations = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"violations", this.getListViolationDescriptors());
            List measures = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"measures", this.getListMeasureDescriptors());
            return new TusarNotifier(tests.toArray(new TestType[tests.size()]), coverages.toArray(new CoverageType[coverages.size()]), violations.toArray(new ViolationsType[violations.size()]), measures.toArray(new MeasureType[measures.size()]));
        }
    }
}

