/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.tusarnotifier;

import com.thalesgroup.dtkit.metrics.api.InputMetric;
import com.thalesgroup.dtkit.metrics.hudson.api.type.CoverageType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MeasureType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MetricsType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.ViolationsType;
import com.thalesgroup.dtkit.util.converter.ConvertException;
import com.thalesgroup.dtkit.util.validator.ValidatorError;
import com.thalesgroup.dtkit.util.validator.ValidatorException;
import com.thalesgroup.hudson.plugins.tusarnotifier.exception.TusarNotifierException;
import com.thalesgroup.hudson.plugins.tusarnotifier.util.TusarNotifierLogger;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TusarTransformer
implements FilePath.FileCallable<String>,
Serializable {
    private TaskListener listener;
    private TestType[] typesTests;
    private CoverageType[] typesCoverage;
    private ViolationsType[] typesViolations;
    private MeasureType[] typesMeasures;

    public TusarTransformer(TaskListener listener, TestType[] typesTests, CoverageType[] typesCoverage, ViolationsType[] typesViolations, MeasureType[] typesMeasures) {
        this.listener = listener;
        this.typesTests = typesTests;
        this.typesCoverage = typesCoverage;
        this.typesViolations = typesViolations;
        this.typesMeasures = typesMeasures;
    }

    private String getDisplayName(MetricsType tool) throws TusarNotifierException {
        if (tool instanceof TestType) {
            return ((TestType)tool).getDescriptor().getDisplayName();
        }
        if (tool instanceof MeasureType) {
            return ((MeasureType)tool).getDescriptor().getDisplayName();
        }
        if (tool instanceof ViolationsType) {
            return ((ViolationsType)tool).getDescriptor().getDisplayName();
        }
        if (tool instanceof CoverageType) {
            return ((CoverageType)tool).getDescriptor().getDisplayName();
        }
        throw new TusarNotifierException();
    }

    private List<String> findtReports(TaskListener listener, MetricsType tool, File parentPath, String pattern) throws TusarNotifierException {
        FileSet fs = Util.createFileSet((File)parentPath, (String)pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] xunitFiles = ds.getIncludedFiles();
        if (xunitFiles.length == 0) {
            String msg = "[ERROR] - No test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the ressource '" + this.getDisplayName(tool) + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the result report(s) for '" + this.getDisplayName(tool) + "'?";
            TusarNotifierLogger.log(listener, msg);
            return null;
        }
        return Arrays.asList(xunitFiles);
    }

    private boolean convertTusar(TaskListener listener, File workspace, File generatedDirectory, MetricsType metricsType) throws TusarNotifierException {
        InputMetric inputMetric = metricsType.getInputMetric();
        Assert.assertNotNull((Object)inputMetric);
        TusarNotifierLogger.log(listener, "Starting to process " + inputMetric.getLabel());
        String curPattern = metricsType.getPattern();
        curPattern = curPattern.replaceAll("[\t\r\n]+", " ");
        List<String> resultFiles = this.findtReports(listener, metricsType, workspace, curPattern);
        if (resultFiles == null || resultFiles.size() == 0) {
            return false;
        }
        try {
            TusarNotifierLogger.log(listener, "[" + this.getDisplayName(metricsType) + "] - Processing " + resultFiles.size() + " files with the pattern '" + metricsType.getPattern() + "' relative to '" + workspace + "'.");
            for (String resultFileName : resultFiles) {
                File resultFile = new File(workspace, resultFileName);
                if (resultFile.length() == 0L) {
                    String msg = "[WARNING] - The file '" + resultFile.getPath() + "' is empty. This file has been ignored.";
                    TusarNotifierLogger.log(listener, msg);
                    for (ValidatorError validatorError : inputMetric.getInputValidationErrors()) {
                        TusarNotifierLogger.log(listener, "[WARNING] " + validatorError.toString());
                    }
                    continue;
                }
                if (!inputMetric.validateInputFile(resultFile)) {
                    TusarNotifierLogger.log(listener, "[WARNING] - The file '" + resultFile + "' is an invalid file. It has been ignored.");
                    continue;
                }
                File tusarTargetFile = new File(generatedDirectory, resultFile.hashCode() + ".xml");
                TusarNotifierLogger.log(listener, "[INFO] - Converting '" + resultFile + "' .");
                inputMetric.convert(resultFile, tusarTargetFile);
                boolean validateOutput = inputMetric.validateOutputFile(tusarTargetFile);
                if (validateOutput) continue;
                TusarNotifierLogger.log(listener, "[WARNING] - The converted file for the input file '" + resultFile + "' doesn't match the TUSAR format");
                for (ValidatorError validatorError : inputMetric.getOutputValidationErrors()) {
                    TusarNotifierLogger.log(listener, "[WARNING] " + validatorError.toString());
                }
                TusarNotifierLogger.log(listener, "Ending to process " + inputMetric.getLabel());
                return false;
            }
        }
        catch (ConvertException ce) {
            throw new TusarNotifierException("Can't convert " + inputMetric, ce);
        }
        catch (ValidatorException vae) {
            throw new TusarNotifierException("Can't validate " + inputMetric, vae);
        }
        TusarNotifierLogger.log(listener, "Ending to process " + inputMetric.getLabel());
        return true;
    }

    public String invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        StringBuffer sb = new StringBuffer();
        String generatedFolder = "generatedTUSARFiles";
        String generatedTests = "generatedTUSARFiles/TESTS";
        String generatedCoverage = "generatedTUSARFiles/COVERAGE";
        String generatedMeasures = "generatedTUSARFiles/MEASURES";
        String generatedViolations = "generatedTUSARFiles/VIOLATIONS";
        try {
            boolean convertOK;
            if (this.typesTests.length != 0) {
                File outputTestsFileParent = new File(workspace, "generatedTUSARFiles/TESTS");
                if (!outputTestsFileParent.mkdirs()) {
                    TusarNotifierLogger.log(this.listener, "Can't create " + outputTestsFileParent + ". Maybe the directory already exists.");
                }
                for (TestType testType : this.typesTests) {
                    convertOK = this.convertTusar(this.listener, workspace, outputTestsFileParent, (MetricsType)testType);
                    if (convertOK) continue;
                    return null;
                }
                sb.append(";").append("generatedTUSARFiles/TESTS");
            }
            if (this.typesCoverage.length != 0) {
                File outputCoverageFileParent = new File(workspace, "generatedTUSARFiles/COVERAGE");
                if (!outputCoverageFileParent.mkdirs()) {
                    TusarNotifierLogger.log(this.listener, "Can't create " + outputCoverageFileParent + ". Maybe the directory already exists.");
                }
                for (TestType testType : this.typesCoverage) {
                    convertOK = this.convertTusar(this.listener, workspace, outputCoverageFileParent, (MetricsType)testType);
                    if (convertOK) continue;
                    return null;
                }
                sb.append(";").append("generatedTUSARFiles/COVERAGE");
            }
            if (this.typesViolations.length != 0) {
                File outputViolationsFileParent = new File(workspace, "generatedTUSARFiles/VIOLATIONS");
                if (!outputViolationsFileParent.mkdirs()) {
                    TusarNotifierLogger.log(this.listener, "Can't create " + outputViolationsFileParent + ". Maybe the directory already exists.");
                }
                for (TestType testType : this.typesViolations) {
                    convertOK = this.convertTusar(this.listener, workspace, outputViolationsFileParent, (MetricsType)testType);
                    if (convertOK) continue;
                    return null;
                }
                sb.append(";").append("generatedTUSARFiles/VIOLATIONS");
            }
            if (this.typesMeasures.length != 0) {
                File outputMeasuresFileParent = new File(workspace, "generatedTUSARFiles/MEASURES");
                if (!outputMeasuresFileParent.mkdirs()) {
                    TusarNotifierLogger.log(this.listener, "Can't create " + outputMeasuresFileParent + ". Maybe the directory already exists.");
                }
                for (TestType testType : this.typesMeasures) {
                    convertOK = this.convertTusar(this.listener, workspace, outputMeasuresFileParent, (MetricsType)testType);
                    if (convertOK) continue;
                    return null;
                }
                sb.append(";").append("generatedTUSARFiles/MEASURES");
            }
            sb.delete(0, 1);
        }
        catch (Exception e) {
            TusarNotifierLogger.log(this.listener, "Tusar notifier error : " + e);
            return null;
        }
        return sb.toString();
    }
}

