/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.tusarnotifier.service;

import com.google.inject.Inject;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MetricsType;
import com.thalesgroup.dtkit.metrics.model.InputMetric;
import com.thalesgroup.dtkit.util.converter.ConversionException;
import com.thalesgroup.hudson.plugins.tusarnotifier.exception.TusarNotifierException;
import com.thalesgroup.hudson.plugins.tusarnotifier.service.TusarNotifierLog;
import com.thalesgroup.hudson.plugins.tusarnotifier.transformer.TusarToolInfo;
import java.io.File;
import java.io.Serializable;

public class TusarNotifierConversionService
implements Serializable {
    private TusarNotifierLog xUnitLog;

    @Inject
    void load(TusarNotifierLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    private void prepareConversion(TusarToolInfo tusarToolInfo, File workspace) throws TusarNotifierException {
        MetricsType metricsType = tusarToolInfo.getMetricsType();
    }

    public File convert(TusarToolInfo tusarToolInfo, File inputFile, File workspace, File outputDirectory) throws TusarNotifierException {
        this.prepareConversion(tusarToolInfo, workspace);
        MetricsType metricsType = tusarToolInfo.getMetricsType();
        InputMetric inputMetric = metricsType.getInputMetric();
        String TUSAR_FILE_POSTFIX = ".xml";
        String TUSAR_FILE_PREFIX = "TUSAR-";
        File junitTargetFile = new File(outputDirectory, "TUSAR-" + inputFile.hashCode() + ".xml");
        this.xUnitLog.info("Converting '" + inputFile + "' .");
        try {
            inputMetric.convert(inputFile, junitTargetFile);
        }
        catch (ConversionException ce) {
            throw new TusarNotifierException("Conversion error", (Throwable)ce);
        }
        return junitTargetFile;
    }
}

