/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.tusarnotifier;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.thalesgroup.dtkit.metrics.hudson.api.type.CoverageType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MeasureType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MetricsType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.ViolationsType;
import com.thalesgroup.hudson.plugins.tusarnotifier.service.TusarNotifierReportProcessingService;
import com.thalesgroup.hudson.plugins.tusarnotifier.transformer.TusarNotifierTransformer;
import com.thalesgroup.hudson.plugins.tusarnotifier.transformer.TusarToolInfo;
import com.thalesgroup.hudson.plugins.tusarnotifier.util.TusarNotifierLogger;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TusarNotifier
extends Notifier {
    private final transient String generatedFolder = "generatedTUSARFiles";
    private final transient String generatedTests = "generatedTUSARFiles/TESTS";
    private final transient String generatedCoverage = "generatedTUSARFiles/COVERAGE";
    private final transient String generatedMeasures = "generatedTUSARFiles/MEASURES";
    private final transient String generatedViolations = "generatedTUSARFiles/VIOLATIONS";
    private TestType[] tests;
    private CoverageType[] coverages;
    private ViolationsType[] violations;
    private MeasureType[] measures;

    public TusarNotifier(TestType[] tests, CoverageType[] coverages, ViolationsType[] violations, MeasureType[] measures) {
        this.tests = tests;
        this.coverages = coverages;
        this.violations = violations;
        this.measures = measures;
    }

    public TestType[] getTests() {
        return this.tests;
    }

    public CoverageType[] getCoverages() {
        return this.coverages;
    }

    public ViolationsType[] getViolations() {
        return this.violations;
    }

    public MeasureType[] getMeasures() {
        return this.measures;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private boolean processInputMetricType(AbstractBuild<?, ?> build, BuildListener listener, MetricsType metricsType, FilePath outputFileParent) throws IOException, InterruptedException {
        TusarNotifierLogger tusarNotifierLog = (TusarNotifierLogger)Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */}).getInstance(TusarNotifierLogger.class);
        String newExpandedPattern = metricsType.getPattern();
        newExpandedPattern = newExpandedPattern.replaceAll("[\t\r\n]+", " ");
        newExpandedPattern = Util.replaceMacro((String)newExpandedPattern, (Map)build.getEnvironment((TaskListener)listener));
        TusarToolInfo tusarToolInfo = new TusarToolInfo(metricsType, new File(outputFileParent.toURI()), newExpandedPattern, build.getTimeInMillis());
        TusarNotifierTransformer tusarNotifierTransformer = (TusarNotifierTransformer)Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */}).getInstance(TusarNotifierTransformer.class);
        boolean resultTransformation = (Boolean)build.getWorkspace().act((FilePath.FileCallable)tusarNotifierTransformer);
        if (!resultTransformation) {
            build.setResult(Result.FAILURE);
            tusarNotifierLog.info("Stopping recording.");
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result;
        FilePath outputFileParent;
        StringBuffer sb = new StringBuffer();
        TusarNotifierLogger tusarNotifierLog = (TusarNotifierLogger)Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */}).getInstance(TusarNotifierLogger.class);
        tusarNotifierLog.info("Starting converting.");
        TusarNotifierReportProcessingService tusarNotifierReportProcessingService = (TusarNotifierReportProcessingService)Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */}).getInstance(TusarNotifierReportProcessingService.class);
        boolean isInvoked = false;
        if (this.tests.length != 0) {
            outputFileParent = new FilePath(build.getWorkspace(), "generatedTUSARFiles/TESTS");
            outputFileParent.mkdirs();
            for (TestType testType : this.tests) {
                tusarNotifierLog.info("Processing " + testType.getDescriptor().getDisplayName());
                if (tusarNotifierReportProcessingService.isEmptyPattern(testType.getPattern()) || !(result = this.processInputMetricType(build, listener, (MetricsType)testType, outputFileParent))) continue;
                isInvoked = true;
            }
            sb.append(";").append("generatedTUSARFiles/TESTS");
        }
        if (this.coverages.length != 0) {
            outputFileParent = new FilePath(build.getWorkspace(), "generatedTUSARFiles/COVERAGE");
            outputFileParent.mkdirs();
            for (TestType testType : this.coverages) {
                tusarNotifierLog.info("Processing " + testType.getDescriptor().getDisplayName());
                if (tusarNotifierReportProcessingService.isEmptyPattern(testType.getPattern()) || !(result = this.processInputMetricType(build, listener, (MetricsType)testType, outputFileParent))) continue;
                isInvoked = true;
            }
            sb.append(";").append("generatedTUSARFiles/COVERAGE");
        }
        if (this.violations.length != 0) {
            outputFileParent = new FilePath(build.getWorkspace(), "generatedTUSARFiles/VIOLATIONS");
            outputFileParent.mkdirs();
            for (TestType testType : this.violations) {
                tusarNotifierLog.info("Processing " + testType.getDescriptor().getDisplayName());
                if (tusarNotifierReportProcessingService.isEmptyPattern(testType.getPattern()) || !(result = this.processInputMetricType(build, listener, (MetricsType)testType, outputFileParent))) continue;
                isInvoked = true;
            }
            sb.append(";").append("generatedTUSARFiles/VIOLATIONS");
        }
        if (this.measures.length != 0) {
            outputFileParent = new FilePath(build.getWorkspace(), "generatedTUSARFiles/MEASURES");
            outputFileParent.mkdirs();
            for (TestType testType : this.measures) {
                tusarNotifierLog.info("Processing " + testType.getDescriptor().getDisplayName());
                if (tusarNotifierReportProcessingService.isEmptyPattern(testType.getPattern()) || !(result = this.processInputMetricType(build, listener, (MetricsType)testType, outputFileParent))) continue;
                isInvoked = true;
            }
            sb.append(";").append("generatedTUSARFiles/MEASURES");
        }
        sb.delete(0, 1);
        ArrayList<StringParameterValue> parameterValues = new ArrayList<StringParameterValue>();
        parameterValues.add(new StringParameterValue("sonar.language", "tusar"));
        parameterValues.add(new StringParameterValue("sonar.tusar.reportsPaths", sb.toString()));
        build.addAction((Action)new ParametersAction(parameterValues));
        return true;
    }
}

