/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.tusarnotifier.service;

import com.google.inject.Inject;
import com.thalesgroup.dtkit.metrics.model.InputMetric;
import com.thalesgroup.dtkit.util.validator.ValidationError;
import com.thalesgroup.dtkit.util.validator.ValidationException;
import com.thalesgroup.hudson.plugins.tusarnotifier.exception.TusarNotifierException;
import com.thalesgroup.hudson.plugins.tusarnotifier.service.TusarNotifierLog;
import com.thalesgroup.hudson.plugins.tusarnotifier.transformer.TusarToolInfo;
import java.io.File;
import java.io.Serializable;

public class TusarNotifierValidationService
implements Serializable {
    private TusarNotifierLog tusarNotifierLog;

    @Inject
    void load(TusarNotifierLog xUnitLog) {
        this.tusarNotifierLog = xUnitLog;
    }

    public boolean checkFileIsNotEmpty(File inputFile) {
        return inputFile.length() != 0L;
    }

    public boolean validateInputFile(TusarToolInfo tusarToolInfo, File inputFile) throws TusarNotifierException {
        InputMetric inputMetric = tusarToolInfo.getMetricsType().getInputMetric();
        try {
            if (!inputMetric.validateInputFile(inputFile)) {
                this.tusarNotifierLog.warning("The file '" + inputFile + "' is an invalid file.");
                for (ValidationError validatorError : inputMetric.getInputValidationErrors()) {
                    this.tusarNotifierLog.warning(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            throw new TusarNotifierException("Validation error on input", (Throwable)ve);
        }
        return true;
    }

    public boolean validateOutputFile(TusarToolInfo tusarToolInfo, File inputFile, File junitTargetFile) throws TusarNotifierException {
        InputMetric inputMetric = tusarToolInfo.getMetricsType().getInputMetric();
        try {
            boolean validateOutput = inputMetric.validateOutputFile(junitTargetFile);
            if (!validateOutput) {
                this.tusarNotifierLog.error("The converted file for the input file '" + inputFile + "' doesn't match the TUSAR format");
                for (ValidationError validatorError : inputMetric.getOutputValidationErrors()) {
                    this.tusarNotifierLog.error(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            throw new TusarNotifierException("Validation error on output", (Throwable)ve);
        }
        return true;
    }
}

