/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.tusarnotifier.service;

import com.google.inject.Inject;
import com.thalesgroup.dtkit.metrics.hudson.api.type.CoverageType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MeasureType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.MetricsType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.type.ViolationsType;
import com.thalesgroup.hudson.plugins.tusarnotifier.service.TusarNotifierLog;
import com.thalesgroup.hudson.plugins.tusarnotifier.transformer.TusarToolInfo;
import hudson.Util;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TusarNotifierReportProcessingService
implements Serializable {
    private TusarNotifierLog xUnitLog;

    @Inject
    void load(TusarNotifierLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public boolean isEmptyPattern(String pattern) {
        return pattern == null || pattern.trim().length() == 0;
    }

    public List<String> findReports(TusarToolInfo tusarToolInfo, File parentPath, String pattern) {
        FileSet fs;
        DirectoryScanner ds;
        String[] xunitFiles;
        MetricsType metricsType = tusarToolInfo.getMetricsType();
        String toolName = null;
        if (metricsType instanceof TestType) {
            toolName = ((TestType)metricsType).getDescriptor().getDisplayName();
        }
        if (metricsType instanceof CoverageType) {
            toolName = ((CoverageType)metricsType).getDescriptor().getDisplayName();
        }
        if (metricsType instanceof ViolationsType) {
            toolName = ((ViolationsType)metricsType).getDescriptor().getDisplayName();
        }
        if (metricsType instanceof MeasureType) {
            toolName = ((MeasureType)metricsType).getDescriptor().getDisplayName();
        }
        if ((xunitFiles = (ds = (fs = Util.createFileSet((File)parentPath, (String)pattern)).getDirectoryScanner()).getIncludedFiles()).length == 0) {
            String msg = "[" + toolName + "] - No test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the testing framework '" + toolName + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the result report(s) for '" + toolName + "'?";
            this.xUnitLog.error(msg);
        } else {
            String msg = "[" + toolName + "] - " + xunitFiles.length + " test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the testing framework '" + toolName + "'.";
            this.xUnitLog.info(msg);
        }
        return Arrays.asList(xunitFiles);
    }

    public boolean checkIfFindsFilesNewFiles(TusarToolInfo tusarToolInfo, List<String> files, File workspace) {
        MetricsType metricsType = tusarToolInfo.getMetricsType();
        if (metricsType.isFaildedIfNotNew()) {
            ArrayList<File> oldResults = new ArrayList<File>();
            for (String value : files) {
                File reportFile = new File(workspace, value);
                if (tusarToolInfo.getBuildTime() - 3000L <= reportFile.lastModified()) continue;
                oldResults.add(reportFile);
            }
            if (!oldResults.isEmpty()) {
                String msg;
                long localTime = System.currentTimeMillis();
                if (localTime < tusarToolInfo.getBuildTime() - 1000L) {
                    msg = "Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.";
                    this.xUnitLog.error(msg);
                    return false;
                }
                msg = "Test reports were found but not all of them are new. Did all the tests run?\n";
                for (File f : oldResults) {
                    msg = msg + String.format("  * %s is %s old\n", f, Util.getTimeSpanString((long)(tusarToolInfo.getBuildTime() - f.lastModified())));
                }
                this.xUnitLog.error(msg);
                return false;
            }
        }
        return true;
    }

    public File getCurrentReport(File root, String name) {
        return new File(root, name);
    }
}

