/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.tusarnotifier.transformer;

import com.google.inject.Inject;
import com.thalesgroup.hudson.plugins.tusarnotifier.exception.TusarNotifierException;
import com.thalesgroup.hudson.plugins.tusarnotifier.service.TusarNotifierConversionService;
import com.thalesgroup.hudson.plugins.tusarnotifier.service.TusarNotifierLog;
import com.thalesgroup.hudson.plugins.tusarnotifier.service.TusarNotifierReportProcessingService;
import com.thalesgroup.hudson.plugins.tusarnotifier.service.TusarNotifierValidationService;
import com.thalesgroup.hudson.plugins.tusarnotifier.transformer.TusarToolInfo;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TusarNotifierTransformer
implements FilePath.FileCallable<Boolean>,
Serializable {
    private TusarNotifierReportProcessingService tusarNotifierReportProcessingService;
    private TusarNotifierConversionService tusarNotifierConversionService;
    private TusarNotifierValidationService tusarNotifierValidationService;
    private TusarToolInfo tusarToolInfo;
    private TusarNotifierLog tusarNotifierLog;

    @Inject
    void loadService(TusarNotifierReportProcessingService tusarNotifierReportProcessingService, TusarNotifierConversionService tusarNotifierConversionService, TusarNotifierValidationService tusarNotifierValidationService, TusarToolInfo tusarToolInfo, TusarNotifierLog tusarNotifierLog) {
        this.tusarNotifierReportProcessingService = tusarNotifierReportProcessingService;
        this.tusarNotifierConversionService = tusarNotifierConversionService;
        this.tusarNotifierValidationService = tusarNotifierValidationService;
        this.tusarToolInfo = tusarToolInfo;
        this.tusarNotifierLog = tusarNotifierLog;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            List<String> resultFiles = this.tusarNotifierReportProcessingService.findReports(this.tusarToolInfo, ws, this.tusarToolInfo.getExpandedPattern());
            if (resultFiles.size() == 0) {
                return false;
            }
            if (!this.tusarNotifierReportProcessingService.checkIfFindsFilesNewFiles(this.tusarToolInfo, resultFiles, ws)) {
                return false;
            }
            for (String curFileName : resultFiles) {
                File curFile = this.tusarNotifierReportProcessingService.getCurrentReport(ws, curFileName);
                if (!this.tusarNotifierValidationService.checkFileIsNotEmpty(curFile)) {
                    String msg = "The file '" + curFile.getPath() + "' is empty. This file has been ignored.";
                    this.tusarNotifierLog.warning(msg);
                    return false;
                }
                if (!this.tusarNotifierValidationService.validateInputFile(this.tusarToolInfo, curFile)) {
                    this.tusarNotifierLog.warning("The file '" + curFile + "' has been ignored.");
                    return false;
                }
                File tusarTargetFile = this.tusarNotifierConversionService.convert(this.tusarToolInfo, curFile, ws, this.tusarToolInfo.getOutputDir());
                boolean result = this.tusarNotifierValidationService.validateOutputFile(this.tusarToolInfo, curFile, tusarTargetFile);
                if (result) continue;
                return false;
            }
        }
        catch (TusarNotifierException xe) {
            throw new IOException2("There are some problems during the conversion into standard output: " + xe.getMessage(), (Throwable)xe);
        }
        return true;
    }
}

