/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tuxdroid;

import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TuxDroidPublisher
extends Publisher {
    private static Object lock = new Object();
    private List<String> voices;
    private final String tuxDroidVoice;
    private final String tuxDroidMacro;
    private final String tuxDroidSuccessTTS;
    private final String tuxDroidRecoverTTS;
    private final String tuxDroidFailTTS;
    public String reportOnSucess = "false";
    private static Logger log = Logger.getLogger(TuxDroidPublisher.class.getName());

    @DataBoundConstructor
    public TuxDroidPublisher(String reportOnSucess, String tuxDroidVoice, String tuxDroidMacro, String tuxDroidSuccessTTS, String tuxDroidRecoverTTS, String tuxDroidFailTTS) {
        this.reportOnSucess = reportOnSucess;
        this.tuxDroidVoice = tuxDroidVoice;
        try {
            this.voices = this.initVoices();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tuxDroidMacro = tuxDroidMacro;
        this.tuxDroidSuccessTTS = tuxDroidSuccessTTS;
        this.tuxDroidRecoverTTS = tuxDroidRecoverTTS;
        this.tuxDroidFailTTS = tuxDroidFailTTS;
    }

    private List<String> initVoices() throws Exception {
        Object list = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getDescriptor().getTuxDroidUrl());
        buf.append("/");
        buf.append(this.getDescriptor().getTuxDroidId());
        buf.append("/tts/voices?");
        String listVoicesRequest = buf.toString();
        URLConnection cnx = ProxyConfiguration.open((URL)new URL(listVoicesRequest));
        cnx.connect();
        inputStream = cnx.getInputStream();
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder result = new StringBuilder();
        String strLine = null;
        while ((strLine = bufferedReader.readLine()) != null) {
            result.append(strLine);
        }
        log.finest("API call result : " + result.toString());
        return this.analyseVoices(result.toString());
    }

    private List<String> analyseVoices(String string) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(string));
            while (xmlStreamReader.hasNext()) {
                String currentElement;
                int next = xmlStreamReader.next();
                if (next != 1 || !(currentElement = xmlStreamReader.getName().getLocalPart()).equals("locutor")) continue;
                String elementText = xmlStreamReader.getElementText();
                list.add(elementText);
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.WARNING, "Unable to read xml Voices result.", e);
        }
        catch (FactoryConfigurationError e) {
            log.log(Level.WARNING, "Unable to create xml parser to read xml Voices result.", e);
        }
        return list;
    }

    public List<String> getVoices() {
        try {
            this.voices = this.initVoices();
        }
        catch (Exception e) {
            return null;
        }
        return this.voices;
    }

    public String getTuxDroidSuccessTTS() {
        return this.tuxDroidSuccessTTS;
    }

    public String getTuxDroidRecoverTTS() {
        return this.tuxDroidRecoverTTS;
    }

    public String getTuxDroidFailTTS() {
        return this.tuxDroidFailTTS;
    }

    public String getTuxDroidVoice() {
        return this.tuxDroidVoice;
    }

    public String getTuxDroidMacro() {
        return this.tuxDroidMacro;
    }

    public boolean isReportOnSucess() {
        return this.reportOnSucess.equalsIgnoreCase("ON");
    }

    private String buildRequest(String message) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getDescriptor().getTuxDroidUrl());
        buf.append("/");
        buf.append(this.getDescriptor().getTuxDroidId());
        buf.append("/tts/speak?");
        buf.append("text=");
        buf.append(message);
        return buf.toString();
    }

    private String moveFlipper() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getDescriptor().getTuxDroidUrl());
        buf.append("/");
        buf.append(this.getDescriptor().getTuxDroidId());
        buf.append("/");
        buf.append("flippers/on_during?");
        buf.append("duration=1.0&final_state=DOWN");
        return buf.toString();
    }

    private String changeVoice() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getDescriptor().getTuxDroidUrl());
        buf.append("/");
        buf.append(this.getDescriptor().getTuxDroidId());
        buf.append("/");
        buf.append("tts/locutor?");
        buf.append("name=" + this.getTuxDroidVoice());
        return buf.toString();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE) {
            String msg = this.getTuxDroidFailTTS();
            log.finest("TuxDroid Build FAILURE");
            this.sendRequest(msg, build, listener);
        } else if (build.getResult() == Result.SUCCESS) {
            if (build.getPreviousBuild() != null && ((AbstractBuild)build.getPreviousBuild()).getResult() == Result.FAILURE) {
                String msg = this.getTuxDroidRecoverTTS();
                log.finest("TuxDroid Build RECOVERY");
                this.sendRequest(msg, build, listener);
            } else if (this.isReportOnSucess()) {
                String msg = this.getTuxDroidSuccessTTS();
                log.finest("TuxDroid Build SUCCESS");
                this.sendRequest(msg, build, listener);
            } else {
                listener.getLogger().println("User has choosed not to be notified of success, notification has not been sent.");
            }
        } else {
            listener.getLogger().println("Build result not handled by TuxDroid notifier, notification has not been sent.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTime(int milliseconds) {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(String message, AbstractBuild<?, ?> build, BuildListener listener) {
        String substituedMessage = StringUtils.replaceEach((String)message, (String[])new String[]{"${projectName}", "${buildNumber}"}, (String[])new String[]{build.getProject().getName(), String.valueOf(build.getNumber())});
        String urlEncodedMessage = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String strLine;
            URLConnection cnx = null;
            String changeVoiceRequest = this.changeVoice();
            log.finest(" sending Tux Droid request : " + changeVoiceRequest);
            cnx = ProxyConfiguration.open((URL)new URL(changeVoiceRequest));
            cnx.connect();
            inputStream = cnx.getInputStream();
            String moveFlipperRequest = this.moveFlipper();
            log.finest(" sending Tux Droid request : " + moveFlipperRequest);
            URLConnection cnx2 = ProxyConfiguration.open((URL)new URL(moveFlipperRequest));
            cnx2.connect();
            inputStream = cnx2.getInputStream();
            this.waitTime(1000);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder result = new StringBuilder();
            while ((strLine = bufferedReader.readLine()) != null) {
                result.append(strLine);
            }
            log.finest("API call result : " + result.toString());
            urlEncodedMessage = URLEncoder.encode(substituedMessage, "UTF-8");
            String requestString = this.buildRequest(urlEncodedMessage);
            log.finest(" sending Tux Droid request : " + requestString);
            URLConnection cnx3 = ProxyConfiguration.open((URL)new URL(requestString));
            cnx3.connect();
            inputStream = cnx3.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            result = new StringBuilder();
            strLine = null;
            while ((strLine = bufferedReader.readLine()) != null) {
                result.append(strLine);
            }
            log.finest("API call result : " + result.toString());
            this.analyseResult(result.toString(), listener);
        }
        catch (UnsupportedEncodingException notFatal) {
            log.log(Level.WARNING, "URL is malformed.", notFatal);
            listener.error("Unable to url encode the Nabaztag message.");
        }
        catch (MalformedURLException dontCare) {
            log.log(Level.WARNING, "URL is malformed.", dontCare);
            listener.error("Unable to build a valid Nabaztag API call.");
        }
        catch (IOException notImportant) {
            log.log(Level.WARNING, "IOException while reading API call result.", notImportant);
            listener.error("TuxDroid has not been successfully notified.");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "IOException while closing API connection.", e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "IOException while closing API connection.", e);
                }
            }
        }
    }

    private void analyseResult(String string, BuildListener listener) {
        ArrayList<String> expectedCommands = new ArrayList<String>(3);
        expectedCommands.add("Success");
        ArrayList<String> unExpectedCommands = new ArrayList<String>();
        try {
            XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(string));
            while (xmlStreamReader.hasNext()) {
                String currentElement;
                int next = xmlStreamReader.next();
                if (next != 1 || !(currentElement = xmlStreamReader.getName().getLocalPart()).equals("result")) continue;
                String elementText = xmlStreamReader.getElementText();
                if (expectedCommands.contains(elementText)) {
                    expectedCommands.remove(elementText);
                    continue;
                }
                unExpectedCommands.add(elementText);
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.WARNING, "Unable to read xml result.", e);
        }
        catch (FactoryConfigurationError e) {
            log.log(Level.WARNING, "Unable to create xml parser to read xml result.", e);
        }
        boolean success = true;
        StringBuilder out = new StringBuilder();
        if (expectedCommands.size() > 0) {
            success = false;
            out.append("Following expected confirmations has not been received: ");
            out.append(((Object)expectedCommands).toString());
            out.append("\n");
        }
        if (unExpectedCommands.size() > 0) {
            success = false;
            out.append("Following unexpected messages has been received: ");
            out.append(((Object)unExpectedCommands).toString());
            out.append(". ");
        }
        if (success) {
            listener.getLogger().println("Tux Droid has been successfully notified.");
        } else {
            listener.getLogger().println("Tux Droid has not been successfully notified: ");
            listener.getLogger().println(out.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        public String tuxDroidUrl = "http://127.0.0.1:270";
        public String tuxDroidId = "0";
        public String tuxDroidVoice;
        public String tuxDroidSuccessTTS;
        public String tuxDroidRecoverTTS;
        public String tuxDroidMacro;
        public String tuxDroidFailTTS;
        public String reportOnSucess;

        public String getTuxDroidId() {
            return this.tuxDroidId;
        }

        public String getTuxDroidUrl() {
            return this.tuxDroidUrl;
        }

        public void setTuxDroidUrl(String tuxDroidUrl) {
            this.tuxDroidUrl = tuxDroidUrl;
        }

        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.tuxDroidUrl = req.getParameter("tuxDroidUrl");
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "TuxDroid Publisher";
        }

        public TuxDroidPublisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            this.reportOnSucess = req.getParameter("reportOnSucess");
            this.tuxDroidFailTTS = req.getParameter("tuxDroidFailTTS");
            this.tuxDroidMacro = req.getParameter("tuxDroidMacro");
            this.tuxDroidRecoverTTS = req.getParameter("tuxDroidRecoverTTS");
            this.tuxDroidSuccessTTS = req.getParameter("tuxDroidSuccessTTS");
            this.tuxDroidVoice = req.getParameter("tuxDroidVoice");
            TuxDroidPublisher m = new TuxDroidPublisher(this.reportOnSucess, this.tuxDroidVoice, this.tuxDroidMacro, this.tuxDroidSuccessTTS, this.tuxDroidRecoverTTS, this.tuxDroidFailTTS);
            return m;
        }
    }
}

