/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tuxdroid;

import com.tuxisalive.api.TuxAPI;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.tuxdroid.TuxDroid;
import hudson.plugins.tuxdroid.TuxDroidPublisher;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.rmi.ConnectException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TuxDroidPublisher
extends Publisher {
    private static Object lock = new Object();
    private List<String> voices;
    private final String tuxDroidVoice;
    private final String tuxDroidMacro;
    private final String tuxDroidSuccessTTS;
    private final String tuxDroidRecoverTTS;
    private final String tuxDroidFailTTS;
    private final String tuxDroidUnstableTTS;
    private TuxAPI tux = null;
    public String reportOnSucess = "false";
    public String animatePenguin = "false";
    private static Logger log = Logger.getLogger(TuxDroidPublisher.class.getName());

    public void connect() {
        try {
            TuxDroid.getInstance().connect(this.getDescriptor().tuxDroidUrl);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void disconnect() {
        try {
            TuxDroid.getInstance().disconnect();
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    @DataBoundConstructor
    public TuxDroidPublisher(String reportOnSucess, String animatePenguin, String tuxDroidVoice, String tuxDroidMacro, String tuxDroidSuccessTTS, String tuxDroidRecoverTTS, String tuxDroidFailTTS, String tuxDroidUnstableTTS) {
        this.connect();
        this.reportOnSucess = reportOnSucess;
        this.animatePenguin = animatePenguin;
        this.tuxDroidVoice = tuxDroidVoice;
        try {
            this.voices = this.initVoices();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tuxDroidMacro = tuxDroidMacro;
        this.tuxDroidSuccessTTS = tuxDroidSuccessTTS;
        this.tuxDroidRecoverTTS = tuxDroidRecoverTTS;
        this.tuxDroidFailTTS = tuxDroidFailTTS;
        this.tuxDroidUnstableTTS = tuxDroidUnstableTTS;
    }

    private List<String> initVoices() {
        List voices = null;
        try {
            voices = TuxDroid.getInstance().getTuxAPI().tts.getVoices();
        }
        catch (ConnectException e) {
            log.info(e.getMessage());
        }
        catch (URISyntaxException e) {
            log.info(e.getMessage());
        }
        catch (NullPointerException e) {
            log.info(e.getMessage());
        }
        return voices;
    }

    public List<String> getVoices() {
        this.connect();
        try {
            this.voices = this.initVoices();
        }
        catch (Exception e) {
            return null;
        }
        return this.voices;
    }

    public String getTuxDroidSuccessTTS() {
        return this.tuxDroidSuccessTTS;
    }

    public String getTuxDroidRecoverTTS() {
        return this.tuxDroidRecoverTTS;
    }

    public String getTuxDroidFailTTS() {
        return this.tuxDroidFailTTS;
    }

    public String getTuxDroidUnstableTTS() {
        return this.tuxDroidUnstableTTS;
    }

    public String getTuxDroidVoice() {
        return this.tuxDroidVoice;
    }

    public String getTuxDroidMacro() {
        return this.tuxDroidMacro;
    }

    public boolean isReportOnSucess() {
        return this.reportOnSucess.equalsIgnoreCase("ON");
    }

    public boolean isAnimatePenguin() {
        if (this.animatePenguin == null) {
            return false;
        }
        return this.animatePenguin.equalsIgnoreCase("ON");
    }

    private void say(String message, BuildListener listener) {
        try {
            if (this.isAnimatePenguin()) {
                TuxDroid.getInstance().getTuxAPI().mouth.onAsync(Integer.valueOf(20), "CLOSE");
            }
            TuxDroid.getInstance().getTuxAPI().tts.speak(message);
            if (this.isAnimatePenguin()) {
                TuxDroid.getInstance().getTuxAPI().mouth.off();
            }
        }
        catch (ConnectException e) {
            log.info(e.getMessage());
        }
        catch (URISyntaxException e) {
            log.info(e.getMessage());
        }
        catch (NullPointerException e) {
            log.info(e.getMessage());
        }
    }

    private void moveFlipper(BuildListener listener) {
        try {
            if (this.isAnimatePenguin()) {
                TuxDroid.getInstance().getTuxAPI().flippers.onDuring(Double.valueOf(1.0), "DOWN");
            }
        }
        catch (ConnectException e) {
            log.info(e.getMessage());
        }
        catch (URISyntaxException e) {
            log.info(e.getMessage());
        }
        catch (NullPointerException e) {
            log.info(e.getMessage());
        }
    }

    private void changeVoice(BuildListener listener) {
        try {
            TuxDroid.getInstance().getTuxAPI().tts.setLocutor(this.getTuxDroidVoice());
        }
        catch (ConnectException e) {
            log.info(e.getMessage());
        }
        catch (URISyntaxException e) {
            log.info(e.getMessage());
        }
        catch (NullPointerException e) {
            log.info(e.getMessage());
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.connect();
        if (build.getResult() == Result.FAILURE) {
            String msg = this.getTuxDroidFailTTS();
            listener.getLogger().println("TuxDroid Build will say FAILURE message");
            this.animate(msg, build, listener);
        } else if (build.getResult() == Result.UNSTABLE) {
            String msg = this.getTuxDroidUnstableTTS();
            listener.getLogger().println("TuxDroid Build will say UNSTABLE message");
            this.animate(msg, build, listener);
        } else if (build.getResult() == Result.SUCCESS) {
            if (build.getPreviousBuild() != null && ((AbstractBuild)build.getPreviousBuild()).getResult() == Result.FAILURE) {
                String msg = this.getTuxDroidRecoverTTS();
                listener.getLogger().println("TuxDroid Build will say RECOVERY message");
                this.animate(msg, build, listener);
            } else if (this.isReportOnSucess()) {
                String msg = this.getTuxDroidSuccessTTS();
                listener.getLogger().println("TuxDroid Build will say SUCCESS message");
                this.animate(msg, build, listener);
            } else {
                listener.getLogger().println("User has choosed not to be notified of success, notification has not been sent.");
            }
        } else {
            listener.getLogger().println("Build result not handled by TuxDroid notifier, notification has not been sent.");
        }
        return true;
    }

    private void animate(String message, AbstractBuild<?, ?> build, BuildListener listener) {
        String substituedMessage = StringUtils.replaceEachRepeatedly((String)message.toUpperCase(), (String[])new String[]{"${PROJECTNAME}", "${BUILDNUMBER}", "${BUILDSTATE}"}, (String[])new String[]{build.getProject().getName(), String.valueOf(build.getNumber()), build.getResult().toString()});
        for (String key : build.getBuildVariables().keySet()) {
            substituedMessage = StringUtils.replaceEachRepeatedly((String)substituedMessage.toUpperCase(), (String[])new String[]{"${" + key.toUpperCase() + "}"}, (String[])new String[]{(String)build.getBuildVariableResolver().resolve(key)});
        }
        String urlEncodedMessage = null;
        this.changeVoice(listener);
        this.moveFlipper(listener);
        try {
            urlEncodedMessage = URLEncoder.encode(substituedMessage, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            listener.getLogger().println("Unsupported Encoding ");
            listener.getLogger().println("Tux Droid has not been notified ");
            return;
        }
        this.say(urlEncodedMessage, listener);
        listener.getLogger().println(substituedMessage);
        listener.getLogger().println("Tux Droid has been successfully notified ");
    }
}

