/*
 * Decompiled with CFR 0.152.
 */
package com.tuxisalive.api;

import com.tuxisalive.api.SLock;
import hudson.ProxyConfiguration;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TuxHTTPRequest {
    private String baseUrl;
    private SLock mutex;

    public TuxHTTPRequest(String host, int port) {
        this.baseUrl = String.format("http://%s:%d", host, port);
        this.mutex = new SLock();
    }

    private Object getValueFromStructure(Hashtable struct, String valuePath) {
        String[] pathList = valuePath.split("\\.");
        Hashtable node = struct;
        Object result = null;
        for (int i = 0; i < pathList.length; ++i) {
            String p = pathList[i];
            if (node.containsKey(p)) {
                if (i == pathList.length - 1) {
                    result = node.get(p);
                    return result;
                }
            } else {
                return result;
            }
            node = (Hashtable)node.get(p);
        }
        return result;
    }

    public Hashtable request(String cmd) {
        return this.request(cmd, "GET");
    }

    public Hashtable request(String cmd, String method) {
        InputSource s;
        cmd = String.format("/%s", cmd);
        System.out.println(cmd);
        Hashtable xmlStruct = new Hashtable();
        String cCmd = String.format("%s%s", this.baseUrl, cmd);
        xmlStruct.put("result", "Failed");
        xmlStruct.put("data_count", 0);
        xmlStruct.put("server_run", "Failed");
        this.mutex.acquire();
        try {
            URLConnection cnx = ProxyConfiguration.open((URL)new URL(cCmd));
            cnx.connect();
            InputStreamReader r = new InputStreamReader(cnx.getInputStream());
            s = new InputSource(r);
        }
        catch (Exception e) {
            this.mutex.release();
            return xmlStruct;
        }
        xmlStruct = this.parseXml(s);
        this.mutex.release();
        return xmlStruct;
    }

    public Boolean request(String cmd, Hashtable varStruct, Hashtable varResult) {
        Hashtable xmlStruct = this.request(cmd);
        if (!xmlStruct.get("server_run").equals("Success")) {
            return false;
        }
        if (!xmlStruct.get("result").equals("Success")) {
            return false;
        }
        if (varStruct.size() > 0) {
            Enumeration e = varStruct.keys();
            while (e.hasMoreElements()) {
                String valueName = (String)e.nextElement();
                String valuePath = (String)varStruct.get(valueName);
                Object value = this.getValueFromStructure(xmlStruct, valuePath);
                varResult.put(valueName, value);
            }
        } else {
            Enumeration e = xmlStruct.keys();
            while (e.hasMoreElements()) {
                Object value = e.nextElement();
                varResult.put(value, xmlStruct.get(value));
            }
        }
        return true;
    }

    private Hashtable parseXml(InputSource s) {
        Hashtable<String, Object> struct = new Hashtable<String, Object>();
        int dataCount = 0;
        String dataNodeName = "";
        struct.put("result", "Failed");
        struct.put("data_count", 0);
        struct.put("server_run", "Success");
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(s);
            doc.getDocumentElement().normalize();
            Node root = doc.getFirstChild();
            root.getChildNodes().getLength();
            for (int iNode = 0; iNode < root.getChildNodes().getLength(); ++iNode) {
                Node node = root.getChildNodes().item(iNode);
                if (node.getFirstChild().getNodeValue() != null) {
                    struct.put(node.getNodeName(), node.getFirstChild().getTextContent());
                    continue;
                }
                Hashtable<String, String> sub_struct = new Hashtable<String, String>();
                for (int jNode = 0; jNode < node.getChildNodes().getLength(); ++jNode) {
                    Node node1 = node.getChildNodes().item(jNode);
                    sub_struct.put(node1.getNodeName(), node1.getFirstChild().getTextContent());
                }
                if (node.getNodeName() == "data") {
                    dataNodeName = String.format("data%d", dataCount);
                    ++dataCount;
                } else {
                    dataNodeName = node.getNodeName();
                }
                struct.put(dataNodeName, sub_struct);
            }
            struct.put("data_count", dataCount);
            struct.put("server_run", "Success");
        }
        catch (Exception e) {
            // empty catch block
        }
        return struct;
    }
}

