/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tuxdroid;

import com.tuxisalive.api.TuxAPI;
import com.tuxisalive.api.TuxAPIConst;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.ConnectException;
import java.util.logging.Logger;

public class TuxDroid {
    private boolean connected = false;
    private TuxAPI tux = null;
    private static TuxDroid instance = null;
    private static Logger log = null;
    URL tuxUrl = null;

    TuxDroid() {
    }

    public static TuxDroid getInstance() {
        if (instance == null) {
            instance = new TuxDroid();
        }
        return instance;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static void setLog(Logger logger) {
        log = logger;
    }

    public static void onAllEvent(String name, String value, Double delay) {
    }

    public static void onSoundEvent(String value, Double delay) {
    }

    public void connect(String tuxDroidUrl) throws Exception {
        if (this.isConnected()) {
            return;
        }
        this.tuxUrl = new URL(tuxDroidUrl);
        this.tux = new TuxAPI(this.tuxUrl.getHost(), Integer.valueOf(this.tuxUrl.getPort()));
        if (!this.tux.server.getConnected().booleanValue()) {
            this.tux.server.autoConnect(TuxAPIConst.CLIENT_LEVEL_RESTRICTED, "hudsonPublisher", "0000");
            this.tux.server.waitConnected(Double.valueOf("0.5"));
            this.tux.event.handler.register("tts_0_sound_state", (Object)this, "onSoundEvent");
            this.connected = true;
        }
        if (!this.tux.server.getConnected().booleanValue()) {
            throw new Exception("Unable to Connect");
        }
    }

    public void disconnect() throws MalformedURLException {
        if (!this.isConnected()) {
            return;
        }
        if (this.tux != null) {
            this.tux.server.disconnect();
            this.connected = false;
        }
    }

    public TuxAPI getTuxAPI() throws ConnectException, URISyntaxException {
        if (this.isConnected()) {
            return this.tux;
        }
        throw new ConnectException(this.tuxUrl.toURI().toString());
    }
}

