/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.twitter;

import hudson.Functions;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.User;
import hudson.plugins.twitter.UserTwitterProperty;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import twitter4j.AsyncTwitter;
import twitter4j.Status;
import twitter4j.TwitterAdapter;
import twitter4j.TwitterException;
import twitter4j.TwitterListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterPublisher
extends Notifier {
    private static final List<String> VALUES_REPLACED_WITH_NULL = Arrays.asList("", "(Default)", "(System Default)");
    private static final Logger LOGGER = Logger.getLogger(TwitterPublisher.class.getName());
    private String id;
    private String password;
    private Boolean onlyOnFailureOrRecovery;
    private Boolean includeUrl;

    private TwitterPublisher(String id, String password, Boolean onlyOnFailureOrRecovery, Boolean includeUrl) {
        this.onlyOnFailureOrRecovery = onlyOnFailureOrRecovery;
        this.includeUrl = includeUrl;
        this.id = id;
        this.password = password;
    }

    @DataBoundConstructor
    public TwitterPublisher(String id, String password, String onlyOnFailureOrRecovery, String includeUrl) {
        this(TwitterPublisher.cleanToString(id), TwitterPublisher.cleanToString(password), TwitterPublisher.cleanToBoolean(onlyOnFailureOrRecovery), TwitterPublisher.cleanToBoolean(includeUrl));
    }

    private static String cleanToString(String string) {
        return VALUES_REPLACED_WITH_NULL.contains(string) ? null : string;
    }

    private static Boolean cleanToBoolean(String string) {
        Boolean result = null;
        if ("true".equals(string) || "Yes".equals(string)) {
            result = Boolean.TRUE;
        } else if ("false".equals(string) || "No".equals(string)) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private static String createTinyUrl(String url) throws IOException {
        HttpClient client = new HttpClient();
        GetMethod gm = new GetMethod("http://tinyurl.com/api-create.php?url=" + url.replace(" ", "%20"));
        int status = client.executeMethod((HttpMethod)gm);
        if (status == 200) {
            return gm.getResponseBodyAsString();
        }
        throw new IOException("Non-OK response code back from tinyurl: " + status);
    }

    public String getId() {
        return this.id;
    }

    public Boolean getIncludeUrl() {
        return this.includeUrl;
    }

    public Boolean getOnlyOnFailureOrRecovery() {
        return this.onlyOnFailureOrRecovery;
    }

    public String getPassword() {
        return this.password;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.shouldTweet(build)) {
            try {
                String newStatus = this.createTwitterStatusMessage(build);
                ((DescriptorImpl)this.getDescriptor()).updateTwit(this.id, this.password, newStatus);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to send tweet.", e);
            }
        }
        return true;
    }

    private String createTwitterStatusMessage(AbstractBuild<?, ?> build) {
        String projectName = build.getProject().getName();
        String result = build.getResult().toString();
        String toblame = "";
        try {
            if (!build.getResult().equals(Result.SUCCESS)) {
                toblame = this.getUserString(build);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String tinyUrl = "";
        if (this.shouldIncludeUrl()) {
            String absoluteBuildURL = ((DescriptorImpl)this.getDescriptor()).getUrl() + build.getUrl();
            try {
                tinyUrl = TwitterPublisher.createTinyUrl(absoluteBuildURL);
            }
            catch (Exception e) {
                tinyUrl = "?";
            }
        }
        return String.format("%s%s:%s $%d - %s", toblame, result, projectName, build.number, tinyUrl);
    }

    private String getUserString(AbstractBuild<?, ?> build) throws IOException {
        StringBuilder userString;
        block3: {
            ChangeLogSet changeSet;
            block2: {
                userString = new StringBuilder("");
                Set culprits = build.getCulprits();
                changeSet = build.getChangeSet();
                if (culprits.size() <= 0) break block2;
                for (User user : culprits) {
                    UserTwitterProperty tid = (UserTwitterProperty)user.getProperty(UserTwitterProperty.class);
                    if (tid.getTwitterid() == null) continue;
                    userString.append("@").append(tid.getTwitterid()).append(" ");
                }
                break block3;
            }
            if (changeSet == null) break block3;
            for (ChangeLogSet.Entry entry : changeSet) {
                User user = entry.getAuthor();
                UserTwitterProperty tid = (UserTwitterProperty)user.getProperty(UserTwitterProperty.class);
                if (tid.getTwitterid() == null) continue;
                userString.append("@").append(tid.getTwitterid()).append(" ");
            }
        }
        return userString.toString();
    }

    protected boolean isFailureOrRecovery(AbstractBuild<?, ?> build) {
        if (build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE) {
            return true;
        }
        if (build.getResult() == Result.SUCCESS) {
            AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
            return previousBuild != null && previousBuild.getResult() != Result.SUCCESS;
        }
        return false;
    }

    protected boolean shouldIncludeUrl() {
        if (this.includeUrl != null) {
            return this.includeUrl;
        }
        return ((DescriptorImpl)this.getDescriptor()).includeUrl;
    }

    protected boolean shouldTweet(AbstractBuild<?, ?> build) {
        if (this.onlyOnFailureOrRecovery == null) {
            if (((DescriptorImpl)this.getDescriptor()).onlyOnFailureOrRecovery) {
                return this.isFailureOrRecovery(build);
            }
            return true;
        }
        if (this.onlyOnFailureOrRecovery.booleanValue()) {
            return this.isFailureOrRecovery(build);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        public String id;
        public String password;
        public String hudsonUrl;
        public boolean onlyOnFailureOrRecovery;
        public boolean includeUrl;

        public DescriptorImpl() {
            super(TwitterPublisher.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.includeUrl = false;
            this.onlyOnFailureOrRecovery = false;
            req.bindParameters((Object)this, "twitter.");
            this.hudsonUrl = Mailer.descriptor().getUrl();
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return "Twitter";
        }

        public String getId() {
            return this.id;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUrl() {
            return this.hudsonUrl;
        }

        public boolean isIncludeUrl() {
            return this.includeUrl;
        }

        public boolean isOnlyOnFailureOrRecovery() {
            return this.onlyOnFailureOrRecovery;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (this.hudsonUrl == null) {
                this.hudsonUrl = Functions.inferHudsonURL((StaplerRequest)req);
                this.save();
            }
            return (Publisher)super.newInstance(req, formData);
        }

        public void updateTwit(String id, String password, String message) throws Exception {
            if (id == null || password == null) {
                id = this.id;
                password = this.password;
            }
            LOGGER.info("Attempting to update Twitter status to: " + message);
            AsyncTwitter twitter = new AsyncTwitter(id, password);
            twitter.updateStatusAsync(message, (TwitterListener)new TwitterAdapter(){

                public void onException(TwitterException e, int method) {
                    LOGGER.warning("Exception updating Twitter status: " + e.toString());
                }

                public void updated(Status statuses) {
                    LOGGER.info("Updated Twitter status: " + statuses.getText());
                }
            });
        }
    }
}

