/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.unityasset.scm;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class UnityChangelog
extends ChangeLogSet.Entry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String author;
    private Date date;
    private String message;
    private Integer serial;
    private List<UnityItem> items = new LinkedList<UnityItem>();

    public UnityChangelog() {
        this.author = "";
        this.date = new Date();
        this.message = "";
    }

    public UnityChangelog(String author, Date date, String message, Integer serial) {
        this.author = author;
        this.date = date;
        this.message = message;
        this.serial = serial;
    }

    public List<UnityItem> getItems() {
        return this.items;
    }

    public void setItems(List<UnityItem> items) {
        this.items = items;
    }

    public Integer getSerial() {
        return this.serial;
    }

    public String getMsg() {
        return DateFormat.getDateTimeInstance(2, 2).format(this.date) + " - " + this.message;
    }

    public User getAuthor() {
        return User.get((String)this.author);
    }

    public Collection<? extends ChangeLogSet.AffectedFile> getAffectedFiles() {
        return this.items;
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (UnityItem item : this.items) {
            paths.add(item.getPath());
        }
        return paths;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnityChangelog other = (UnityChangelog)obj;
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    public static class UnityItem
    implements ChangeLogSet.AffectedFile {
        private Integer action;
        private String message;

        public UnityItem(String message, Integer action) {
            this.action = action;
            this.message = message;
        }

        public String getPath() {
            return this.message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Exported
        public EditType getEditType() {
            if (this.action == 1) {
                return EditType.ADD;
            }
            if (this.action == 0) {
                return EditType.EDIT;
            }
            if (this.action == 2) {
                return EditType.DELETE;
            }
            return EditType.EDIT;
        }
    }
}

