/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.unityasset.scm;

import hudson.model.AbstractBuild;
import hudson.plugins.unityasset.scm.UnityChangelog;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnityChangelogSet
extends ChangeLogSet<UnityChangelog> {
    private List<UnityChangelog> logs = new ArrayList<UnityChangelog>();

    public UnityChangelogSet(AbstractBuild build, List<UnityChangelog> changes) {
        super(build);
        this.logs.addAll(changes);
    }

    public String getKind() {
        return "unity_scm";
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public Iterator<UnityChangelog> iterator() {
        return Collections.unmodifiableList(this.logs).iterator();
    }

    public static class XMLSerializer
    extends ChangeLogParser {
        private transient XStream2 xstream;

        private Object readResolve() {
            this.initXStream();
            return this;
        }

        public XMLSerializer() {
            this.initXStream();
        }

        private void initXStream() {
            this.xstream = new XStream2();
            this.xstream.alias("log", UnityChangelogSet.class);
            this.xstream.alias("changelog", UnityChangelog.class);
            this.xstream.omitField(ChangeLogSet.class, "build");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UnityChangelogSet parse(AbstractBuild build, File file) throws FileNotFoundException {
            FileInputStream in = null;
            UnityChangelogSet out = null;
            try {
                in = new FileInputStream(file);
                out = (UnityChangelogSet)((Object)this.xstream.fromXML((InputStream)in));
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((InputStream)in);
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(UnityChangelogSet changeLogSet, File file) throws FileNotFoundException {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                this.xstream.toXML((Object)changeLogSet, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

