/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.hudsonci.plugins.vault.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bundle
implements Comparable<Bundle>,
Serializable {
    private final String name;
    private String type;
    private Set<Package> packages;
    private String description;

    public Bundle(String name) {
        this.name = name;
    }

    public Bundle(String name, Bundle bundle) {
        assert (name != null);
        this.name = name;
        assert (bundle != null);
        this.type = bundle.getType();
        this.packages = bundle.getPackages();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<Package> getPackages() {
        if (this.packages == null) {
            this.packages = new HashSet();
        }
        return this.packages;
    }

    public void setPackages(Set<Package> packages) {
        this.packages = packages;
    }

    public Package getPackage(String id) {
        assert (id != null);
        return this.getPackage(UUID.fromString(id));
    }

    private Package getPackage(UUID id) {
        assert (id != null);
        if (this.packages != null) {
            for (Package pkg : this.packages) {
                if (!id.equals(pkg.getId())) continue;
                return pkg;
            }
        }
        return null;
    }

    public void addPackage(Package pkg) {
        assert (pkg != null);
        this.packages.add(pkg);
    }

    public void removePackage(Package pkg) {
        assert (pkg != null);
        this.packages.remove(pkg);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Bundle that = (Bundle)obj;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public int compareTo(Bundle bundle) {
        return this.name.compareTo(bundle.getName());
    }

    public String toString() {
        return "Bundle{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", packages=" + this.packages + '}';
    }
}

