/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault;

import hudson.model.Hudson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.hudsonci.plugins.vault.Bundle;
import org.hudsonci.plugins.vault.DuplicateBundleException;
import org.hudsonci.plugins.vault.NoSuchBundleException;
import org.hudsonci.plugins.vault.Package;
import org.hudsonci.plugins.vault.VaultPlugin;
import org.hudsonci.plugins.vault.util.Archiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Vault
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Vault.class);
    private transient VaultPlugin plugin;
    private transient Archiver archiver;
    private File storeDir;
    private transient File rootDir;
    private transient File cacheDir;
    private transient File uploadDir;
    private final Set<Bundle> bundles = new TreeSet();
    private static Vault vault;

    public Vault(VaultPlugin plugin) {
        assert (plugin != null);
        this.plugin = plugin;
    }

    private Object readResolve() {
        this.plugin = (VaultPlugin)Hudson.getInstance().getPlugin(VaultPlugin.class);
        for (Bundle bundle : this.bundles) {
            for (Package pkg : bundle.getPackages()) {
                pkg.setCacheFile(this.getCacheFile(bundle, pkg));
            }
        }
        return this;
    }

    public void save() throws IOException {
        this.plugin.save();
    }

    public static Vault get() {
        if (vault == null) {
            vault = ((VaultPlugin)Hudson.getInstance().getPlugin(VaultPlugin.class)).getVault();
        }
        return vault;
    }

    public File getStoreDir() {
        if (this.storeDir == null) {
            this.storeDir = new File(Hudson.getInstance().getRootDir(), "vault");
        }
        return this.storeDir;
    }

    public void setStoreDir(File dir) {
        this.storeDir = dir;
    }

    public File getRootDir() {
        if (this.rootDir == null) {
            return new File(this.getStoreDir(), "root");
        }
        return this.rootDir;
    }

    public void setRootDir(File dir) {
        this.rootDir = dir;
    }

    public File getCacheDir() {
        if (this.cacheDir == null) {
            return new File(this.getStoreDir(), "cache");
        }
        return this.cacheDir;
    }

    public void setCacheDir(File dir) {
        this.cacheDir = dir;
    }

    public File getUploadsDir() {
        if (this.uploadDir == null) {
            return new File(this.getStoreDir(), "uploads");
        }
        return this.uploadDir;
    }

    public void setUploadDir(File dir) {
        this.uploadDir = dir;
    }

    public Collection<Bundle> getBundles() {
        return this.bundles;
    }

    public Bundle getBundle(String name) {
        assert (name != null);
        for (Bundle bundle : this.bundles) {
            if (!name.equals(bundle.getName())) continue;
            return bundle;
        }
        return null;
    }

    public Collection<Bundle> findBundles(String type) {
        Collection bundles = this.getBundles();
        if (type == null) {
            return bundles;
        }
        ArrayList<Bundle> found = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            if (!type.equals(bundle.getType())) continue;
            found.add(bundle);
        }
        return found;
    }

    public Bundle addBundle(Bundle bundle) throws Exception {
        assert (bundle != null);
        log.info("Creating bundle: {}", (Object)bundle);
        if (this.getBundle(bundle.getName()) != null) {
            throw new DuplicateBundleException(bundle.getName());
        }
        this.bundles.add(bundle);
        this.save();
        return bundle;
    }

    public void removeBundle(String name) throws Exception {
        Bundle bundle = this.getBundle(name);
        log.info("Removing bundle: {}", (Object)name);
        if (bundle == null) {
            throw new NoSuchBundleException(name);
        }
        this.bundles.remove(bundle);
        this.save();
        for (Package pkg : bundle.getPackages()) {
            this.removePackageCache(bundle, pkg);
        }
    }

    public void renameBundle(String source, String target) throws Exception {
        assert (source != null);
        assert (target != null);
        log.info("Renaming bundle: {} -> {}", (Object)source, (Object)target);
        Bundle bundle = this.getBundle(source);
        if (bundle == null) {
            throw new NoSuchBundleException(source);
        }
        if (this.getBundle(target) != null) {
            throw new DuplicateBundleException(source);
        }
        this.bundles.remove(bundle);
        bundle = new Bundle(target, bundle);
        this.bundles.add(bundle);
        this.save();
        for (Package pkg : bundle.getPackages()) {
            this.removePackageCache(bundle, pkg);
        }
    }

    private Archiver getArchiver() {
        if (this.archiver == null) {
            this.archiver = new Archiver();
        }
        return this.archiver;
    }

    public File resolvePath(String path) {
        assert (path != null);
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        return new File(Vault.get().getRootDir(), path);
    }

    private File getCacheFile(Bundle bundle, Package pkg) {
        assert (bundle != null);
        assert (pkg != null);
        String name = String.format("%s,%s.zip", bundle.getName(), pkg.getId());
        return new File(this.getCacheDir(), name);
    }

    private File getSourceDir(Package pkg) {
        assert (pkg != null);
        return this.resolvePath(pkg.getPath());
    }

    public File buildPackageCache(Bundle bundle, Package pkg) throws IOException {
        File source;
        assert (bundle != null);
        assert (pkg != null);
        File file = this.getCacheFile(bundle, pkg);
        log.info("Building package cache: {}", (Object)file);
        if (file.exists() && !file.delete()) {
            log.error("Failed to remove old cache: {}", (Object)file);
        }
        if (!(source = this.getSourceDir(pkg)).exists()) {
            throw new FileNotFoundException(source.getAbsolutePath());
        }
        this.getArchiver().archive(pkg, file, source);
        pkg.setCacheFile(file);
        return file;
    }

    public void removePackageCache(Bundle bundle, Package pkg) {
        assert (bundle != null);
        assert (pkg != null);
        File file = this.getCacheFile(bundle, pkg);
        log.info("Removing package cache: {}", (Object)file);
        if (file.exists() && !file.delete()) {
            log.error("Failed to remove cache: {}", (Object)file);
        }
        pkg.setCacheFile(null);
    }
}

