/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault;

import com.thoughtworks.xstream.XStream;
import hudson.Plugin;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.hudsonci.plugins.vault.Bundle;
import org.hudsonci.plugins.vault.Package;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.tool.AntInstaller;
import org.hudsonci.plugins.vault.tool.JdkInstaller;
import org.hudsonci.plugins.vault.tool.LegacyMavenInstaller;
import org.hudsonci.utils.plugin.PluginUtil;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class VaultPlugin
extends Plugin
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Vault.class);
    private static final XStream XSTREAM = new XStream2();
    private Vault vault;

    public String getShortName() {
        return PluginUtil.getWrapper((Plugin)this).getShortName();
    }

    public Vault getVault() {
        if (this.vault == null) {
            this.vault = new Vault(this);
        }
        return this.vault;
    }

    public void start() throws Exception {
        Hudson.XSTREAM.processAnnotations(new Class[]{AntInstaller.class, JdkInstaller.class, LegacyMavenInstaller.class});
    }

    public void postInitialize() throws Exception {
        this.load();
        Vault vault = this.getVault();
        File dir = vault.getStoreDir();
        log.info("Storage directory: {}", (Object)dir);
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(XSTREAM, new File(Hudson.getInstance().getRootDir(), this.getShortName() + ".xml"));
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        assert (req != null);
        assert (formData != null);
        String dir = formData.getString("storeDir");
        File file = new File(dir);
        this.vault.setStoreDir(file);
        this.save();
    }

    static {
        XSTREAM.alias("bundle", Bundle.class);
        XSTREAM.alias("package", Package.class);
    }
}

