/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.install;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import org.hudsonci.plugins.vault.Package;
import org.hudsonci.plugins.vault.install.InstallScriptExecutor;
import org.hudsonci.plugins.vault.install.PackageInstallListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallScriptExecutor
implements PackageInstallListener {
    private static final Logger log = LoggerFactory.getLogger(InstallScriptExecutor.class);

    public void installed(Package pkg, FilePath location, TaskListener listener) throws Exception {
        FilePath script = location.child("install.groovy");
        if (script.exists()) {
            String msg = String.format("Executing installation script: %s", script);
            log.info(msg);
            listener.getLogger().println(msg);
            ExecuteScript task = new ExecuteScript(script, null);
            String result = (String)location.getChannel().call((Callable)task);
            log.info("Script result:\n{}", (Object)result);
            listener.getLogger().println(result);
        }
    }
}

