/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.install;

import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hudsonci.plugins.vault.install.NodeContext;
import org.hudsonci.plugins.vault.slave.CustomNodeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class NodeContext
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(NodeContext.class);
    private final Map<String, String> attributes;
    private final Properties systemProperties;
    private static Map<Node, NodeContext> cache = Collections.synchronizedMap(new HashMap());

    private NodeContext(Map<String, String> attributes, Properties systemProperties) {
        assert (attributes != null);
        this.attributes = attributes;
        assert (systemProperties != null);
        this.systemProperties = systemProperties;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public String toString() {
        return "NodeContext{attributes=" + this.attributes + '}';
    }

    public static NodeContext fetch(Node node, VirtualChannel channel) throws IOException, InterruptedException {
        assert (node != null);
        assert (channel != null);
        log.debug("Fetching context for node: {} on channel: {}", (Object)node.getDisplayName(), (Object)channel);
        NodeContext context = (NodeContext)channel.call((Callable)new FetchContext(null));
        assert (context != null);
        for (NodeProperty prop : node.getNodeProperties()) {
            if (!(prop instanceof CustomNodeContext)) continue;
            ((CustomNodeContext)prop).applyTo(context);
        }
        return context;
    }

    public static NodeContext get(Node node, VirtualChannel channel) throws IOException, InterruptedException {
        NodeContext context = (NodeContext)cache.get(node);
        if (context == null) {
            context = NodeContext.fetch((Node)node, (VirtualChannel)channel);
            cache.put(node, context);
        }
        return context;
    }

    public static Map<Node, NodeContext> getCache() {
        return cache;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }
}

