/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.install;

import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hudsonci.plugins.vault.Package;
import org.hudsonci.plugins.vault.install.InstallScriptExecutor;
import org.hudsonci.plugins.vault.install.NodeContext;
import org.hudsonci.plugins.vault.install.PackageInstallListener;
import org.hudsonci.plugins.vault.install.PackageSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageInstaller {
    private static final Logger log = LoggerFactory.getLogger(PackageInstaller.class);
    private String bundleName;
    private FilePath location;
    private Node node;
    private VirtualChannel channel;
    private TaskListener listener;
    private final List<PackageInstallListener> installListeners = new ArrayList();

    public PackageInstaller() {
        this.addInstallListener((PackageInstallListener)new InstallScriptExecutor());
    }

    public String getBundleName() {
        if (this.bundleName == null) {
            throw new IllegalStateException("Bundle name not configured");
        }
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public FilePath getLocation() {
        if (this.location == null) {
            throw new IllegalStateException("Location not configured");
        }
        return this.location;
    }

    public void setLocation(FilePath location) {
        this.location = location;
    }

    public Node getNode() {
        if (this.node == null) {
            throw new IllegalStateException("Node not configured");
        }
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public VirtualChannel getChannel() {
        if (this.channel == null) {
            this.channel = this.getNode().getChannel();
        }
        if (this.channel == null) {
            throw new IllegalStateException("Channel not configured; unable to detect");
        }
        return this.channel;
    }

    public void setChannel(VirtualChannel channel) {
        this.channel = channel;
    }

    public TaskListener getListener() {
        if (this.listener == null) {
            this.listener = TaskListener.NULL;
        }
        return this.listener;
    }

    public void setListener(TaskListener listener) {
        this.listener = listener;
    }

    public Collection<PackageInstallListener> getInstallListeners() {
        return this.installListeners;
    }

    public void addInstallListener(PackageInstallListener listener) {
        this.installListeners.add(listener);
    }

    public void removeInstallListener(PackageInstallListener listener) {
        this.installListeners.remove(listener);
    }

    private Package selectPackage() throws Exception {
        PackageSelector selector = new PackageSelector();
        selector.setBundleName(this.getBundleName());
        NodeContext context = NodeContext.get((Node)this.getNode(), (VirtualChannel)this.getChannel());
        selector.setContext(context);
        return selector.select();
    }

    public FilePath install() throws Exception {
        log.debug("Installing package for bundle: {} on: {}", (Object)this.getBundleName(), (Object)this.getNode().getDisplayName());
        Package pkg = this.selectPackage();
        log.debug("Selected package: {}", (Object)pkg);
        FilePath location = this.getLocation();
        log.debug("Install location: {}", (Object)location);
        String msg = String.format("Installing package for bundle: %s (%s) to: %s", this.getBundleName(), pkg.getId(), location);
        if (location.installIfNecessaryFrom(pkg.getCacheFile().toURI().toURL(), this.getListener(), msg)) {
            for (PackageInstallListener listener : this.getInstallListeners()) {
                try {
                    listener.installed(pkg, location, this.getListener());
                }
                catch (Exception e) {
                    log.error("Install listener execution failed: {}", (Throwable)e);
                }
            }
            msg = "Package installed";
            log.debug(msg);
            this.getListener().getLogger().println(msg);
        } else {
            log.debug("Package is already installed");
        }
        return location;
    }

    public String toString() {
        return "PackageInstaller{bundleName='" + this.bundleName + '\'' + ", location=" + this.location + ", node=" + this.node + ", channel=" + this.channel + ", listener=" + this.listener + ", installListeners=" + this.installListeners + '}';
    }
}

