/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.slave;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.hudsonci.plugins.vault.install.NodeContext;
import org.hudsonci.plugins.vault.install.PackageInstaller;
import org.hudsonci.plugins.vault.slave.NodeOnlineInstaller;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeOnlineInstaller
extends NodeProperty<Node> {
    private static final Logger log = LoggerFactory.getLogger(NodeOnlineInstaller.class);
    private final List<Entry> entries;

    @DataBoundConstructor
    public NodeOnlineInstaller(List<Entry> config) {
        this.entries = config;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    private void install(Computer c, Channel channel, FilePath root, TaskListener listener) throws Exception {
        assert (c != null);
        assert (channel != null);
        assert (root != null);
        assert (listener != null);
        if (this.entries == null || this.entries.isEmpty()) {
            return;
        }
        log.debug("Installing packages on: {}", (Object)c.getDisplayName());
        NodeContext context = NodeContext.get((Node)c.getNode(), (VirtualChannel)channel);
        for (Entry entry : this.entries) {
            log.debug("Entry: {}", (Object)entry);
            PackageInstaller installer = new PackageInstaller();
            installer.setBundleName(entry.getName());
            String path = entry.getPath();
            if (path == null || path.trim().length() == 0) {
                path = entry.getName();
            }
            installer.setLocation(this.resolveLocation(context, root, path));
            installer.setNode(c.getNode());
            installer.setChannel((VirtualChannel)channel);
            installer.setListener(listener);
            try {
                installer.install();
            }
            catch (Exception e) {
                listener.error("Package installation failed: %s", new Object[]{e});
            }
        }
    }

    private FilePath resolveLocation(NodeContext context, FilePath root, String path) throws Exception {
        assert (context != null);
        assert (root != null);
        assert (path != null);
        StringSearchInterpolator interp = new StringSearchInterpolator();
        interp.addValueSource((ValueSource)new PropertiesBasedValueSource(context.getSystemProperties()));
        String location = interp.interpolate(path);
        FilePath base = root.child("vault").child("install");
        FilePath file = base.child(location);
        return file.absolutize();
    }

    public Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        NodeContext context = NodeContext.get((Node)build.getBuiltOn(), (VirtualChannel)launcher.getChannel());
        PrintStream logger = listener.getLogger();
        logger.println("Node context:");
        for (Map.Entry attr : context.getAttributes().entrySet()) {
            logger.printf("  %s=%s", attr.getKey(), attr.getValue()).println();
        }
        return super.setUp(build, launcher, listener);
    }

    public String toString() {
        return "NodeOnlineInstaller{entries=" + this.entries + '}';
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(NodeOnlineInstaller x0, Computer x1, Channel x2, FilePath x3, TaskListener x4) throws Exception {
        x0.install(x1, x2, x3, x4);
    }
}

