/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.tool;

import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import java.io.IOException;
import java.io.Serializable;
import org.hudsonci.plugins.vault.install.PackageInstallListener;
import org.hudsonci.plugins.vault.install.PackageInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToolInstallerSupport
extends ToolInstaller
implements Serializable {
    protected transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final String bundleName;

    protected ToolInstallerSupport(String bundleName) {
        super(null);
        assert (bundleName != null);
        this.bundleName = bundleName;
    }

    private Object readResolve() {
        this.log = LoggerFactory.getLogger(this.getClass());
        return this;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener listener) throws IOException, InterruptedException {
        assert (listener != null);
        PackageInstaller installer = new PackageInstaller();
        installer.setBundleName(this.getBundleName());
        installer.setNode(node);
        installer.setListener(listener);
        FilePath location = this.preferredLocation(tool, node);
        installer.setLocation(location);
        if (this instanceof PackageInstallListener) {
            installer.addInstallListener((PackageInstallListener)this);
        }
        try {
            location = installer.install();
        }
        catch (Exception e) {
            listener.fatalError("Package installation failed: %s", new Object[]{e});
            e.printStackTrace(listener.getLogger());
        }
        return location;
    }
}

