/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.ui;

import com.google.common.collect.Multimap;
import hudson.model.Action;
import java.util.Collection;
import org.hudsonci.plugins.vault.Bundle;
import org.hudsonci.plugins.vault.Package;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.ui.PackageUI;
import org.hudsonci.plugins.vault.ui.VaultUI;
import org.hudsonci.plugins.vault.util.MultimapUtil;
import org.hudsonci.utils.plugin.ui.AdministratorUIComponent;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.hudsonci.utils.plugin.ui.StaplerAccessible;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleUI
extends AdministratorUIComponent<VaultUI> {
    private final Bundle data;

    public BundleUI(VaultUI parent, Bundle data) {
        super((Action)parent);
        assert (data != null);
        this.data = data;
    }

    @JellyAccessible
    public Bundle getData() {
        return this.data;
    }

    @JellyAccessible
    public Collection<Package> getPackages() {
        return this.data.getPackages();
    }

    public String getDisplayName() {
        return this.data.getName();
    }

    public String getIconFileName() {
        return this.getIconFileName("archive-icon-48x48.png");
    }

    @StaplerAccessible
    public Object getDynamic(String id, StaplerRequest req, StaplerResponse resp) {
        Package pkg = this.data.getPackage(id);
        if (pkg != null) {
            return new PackageUI(this, pkg);
        }
        return null;
    }

    @JellyAccessible
    public String renderProperties(Package pkg) {
        assert (pkg != null);
        return MultimapUtil.save((Multimap)pkg.getProperties(), (String)"<br/>");
    }

    @StaplerAccessible
    public void doUpdate(StaplerRequest req, StaplerResponse resp, @QueryParameter(value="name", required=true, fixEmpty=true) String name, @QueryParameter(value="type", required=true, fixEmpty=true) String type, @QueryParameter(value="description", required=false, fixEmpty=true) String description) throws Exception {
        this.checkPermission();
        this.data.setType(type);
        this.data.setDescription(description);
        if (!this.data.getName().equals(name)) {
            Vault.get().renameBundle(this.data.getName(), name);
        } else {
            Vault.get().save();
        }
        this.redirectSelf(req, resp);
    }

    @StaplerAccessible
    public void doDelete(StaplerRequest req, StaplerResponse resp) throws Exception {
        this.checkPermission();
        Vault.get().removeBundle(this.data.getName());
        this.redirectParent(req, resp);
    }

    @StaplerAccessible
    public void doCreatePackage(StaplerRequest req, StaplerResponse resp, @QueryParameter(value="path", required=true, fixEmpty=true) String path, @QueryParameter(value="includes", required=false, fixEmpty=true) String includes, @QueryParameter(value="excludes", required=false, fixEmpty=true) String excludes, @QueryParameter(value="properties", required=false, fixEmpty=true) String properties, @QueryParameter(value="description", required=false, fixEmpty=true) String description) throws Exception {
        this.checkPermission();
        Package pkg = new Package();
        pkg.setPath(path);
        pkg.setIncludes(includes);
        pkg.setExcludes(excludes);
        if (properties != null && properties.trim().length() != 0) {
            MultimapUtil.load((Multimap)pkg.getProperties(), (String)properties);
        }
        pkg.setDescription(description);
        this.data.addPackage(pkg);
        Vault.get().buildPackageCache(this.data, pkg);
        Vault.get().save();
        this.redirectSelf(req, resp);
    }
}

