/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.ui;

import com.google.common.collect.Multimap;
import hudson.model.Action;
import org.hudsonci.plugins.vault.Package;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.ui.BundleUI;
import org.hudsonci.plugins.vault.util.MultimapUtil;
import org.hudsonci.utils.plugin.ui.AdministratorUIComponent;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.hudsonci.utils.plugin.ui.StaplerAccessible;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageUI
extends AdministratorUIComponent<BundleUI> {
    private final Package data;

    public PackageUI(BundleUI parent, Package data) {
        super((Action)parent);
        assert (data != null);
        this.data = data;
    }

    @JellyAccessible
    public Package getData() {
        return this.data;
    }

    public String getDisplayName() {
        return this.data.getId().toString();
    }

    public String getIconFileName() {
        return this.getIconFileName("archive-icon-48x48.png");
    }

    @JellyAccessible
    public String getProperties() {
        return MultimapUtil.save((Multimap)this.data.getProperties());
    }

    @StaplerAccessible
    public void doUpdate(StaplerRequest req, StaplerResponse resp, @QueryParameter(value="path", required=true, fixEmpty=true) String path, @QueryParameter(value="includes", required=false, fixEmpty=true) String includes, @QueryParameter(value="excludes", required=false, fixEmpty=true) String excludes, @QueryParameter(value="properties", required=false, fixEmpty=true) String properties, @QueryParameter(value="description", required=false, fixEmpty=true) String description) throws Exception {
        this.checkPermission();
        this.data.setPath(path);
        this.data.setIncludes(includes);
        this.data.setExcludes(excludes);
        if (properties != null && properties.trim().length() != 0) {
            MultimapUtil.load((Multimap)this.data.getProperties(), (String)properties);
        } else {
            this.data.setProperties(null);
        }
        this.data.setDescription(description);
        Vault.get().buildPackageCache(((BundleUI)this.getParent()).getData(), this.data);
        Vault.get().save();
        this.redirectSelf(req, resp);
    }

    @StaplerAccessible
    public void doDelete(StaplerRequest req, StaplerResponse resp) throws Exception {
        this.checkPermission();
        ((BundleUI)this.getParent()).getData().removePackage(this.data);
        Vault.get().removePackageCache(((BundleUI)this.getParent()).getData(), this.data);
        Vault.get().save();
        this.redirectParent(req, resp);
    }

    @StaplerAccessible
    public void doRefresh(StaplerRequest req, StaplerResponse resp) throws Exception {
        this.checkPermission();
        Vault.get().buildPackageCache(((BundleUI)this.getParent()).getData(), this.data);
        Vault.get().save();
        this.redirectParent(req, resp);
    }
}

