/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.ui;

import hudson.FilePath;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import java.io.File;
import org.hudsonci.plugins.vault.Bundle;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.ui.BundleUI;
import org.hudsonci.plugins.vault.ui.UploadsUI;
import org.hudsonci.plugins.vault.ui.VaultLink;
import org.hudsonci.utils.plugin.ui.AdministratorUIComponent;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.hudsonci.utils.plugin.ui.StaplerAccessible;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VaultUI
extends AdministratorUIComponent<VaultLink> {
    private Vault vault;

    public VaultUI(VaultLink parent) {
        super((Action)parent);
    }

    public String getDisplayName() {
        return "Vault";
    }

    @JellyAccessible
    public Vault getVault() {
        if (this.vault == null) {
            this.vault = Vault.get();
        }
        return this.vault;
    }

    private DirectoryBrowserSupport browse(File dir, String title) {
        this.checkPermission();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new DirectoryBrowserSupport((ModelObject)this, new FilePath(dir), String.format("%s %s", this.getDisplayName(), title), "folder.gif", true);
    }

    @StaplerAccessible
    public DirectoryBrowserSupport doFiles(StaplerRequest req, StaplerResponse resp) {
        return this.browse(this.getVault().getRootDir(), "Files");
    }

    @StaplerAccessible
    public DirectoryBrowserSupport doCache(StaplerRequest req, StaplerResponse resp) {
        return this.browse(this.getVault().getCacheDir(), "Cache");
    }

    @StaplerAccessible
    public Object getBundle(String name) {
        Bundle bundle = this.getVault().getBundle(name);
        if (bundle != null) {
            return new BundleUI(this, bundle);
        }
        return null;
    }

    @StaplerAccessible
    public void doCreateBundle(StaplerRequest req, StaplerResponse resp, @QueryParameter(value="name", required=true, fixEmpty=true) String name, @QueryParameter(value="type", required=true, fixEmpty=true) String type, @QueryParameter(value="description", required=false, fixEmpty=true) String description) throws Exception {
        this.checkPermission();
        Bundle bundle = new Bundle(name);
        bundle.setType(type);
        bundle.setDescription(description);
        this.getVault().addBundle(bundle);
        this.redirectParent(req, resp);
    }

    @StaplerAccessible
    public Object getUploads() {
        return new UploadsUI(this);
    }
}

