/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.install;

import groovy.lang.GroovyShell;
import hudson.FilePath;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.DelegatingCallable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.hudsonci.plugins.vault.Package;
import org.hudsonci.plugins.vault.install.PackageInstallListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallScriptExecutor
implements PackageInstallListener {
    private static final Logger log = LoggerFactory.getLogger(InstallScriptExecutor.class);

    public void installed(Package pkg, FilePath location, TaskListener listener) throws Exception {
        FilePath script = location.child("install.groovy");
        if (script.exists()) {
            String msg = String.format("Executing installation script: %s", script);
            log.info(msg);
            listener.getLogger().println(msg);
            ExecuteScript task = new ExecuteScript(script);
            String result = (String)location.getChannel().call((Callable)task);
            log.info("Script result:\n{}", (Object)result);
            listener.getLogger().println(result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExecuteScript
    implements DelegatingCallable<String, RuntimeException> {
        private final FilePath script;
        private transient ClassLoader cl;

        private ExecuteScript(FilePath script) {
            this.script = script;
            this.cl = this.getClassLoader();
        }

        public ClassLoader getClassLoader() {
            return Hudson.getInstance().getPluginManager().uberClassLoader;
        }

        public String call() throws RuntimeException {
            if (this.cl == null) {
                this.cl = Thread.currentThread().getContextClassLoader();
            }
            GroovyShell shell = new GroovyShell(this.cl);
            File file = new File(this.script.getRemote());
            File baseDir = file.getParentFile();
            shell.setVariable("baseDir", (Object)baseDir);
            shell.setVariable("basedir", (Object)baseDir);
            StringWriter buff = new StringWriter();
            PrintWriter out = new PrintWriter(buff);
            shell.setVariable("out", (Object)out);
            try {
                Object output = shell.evaluate(file);
                if (output != null) {
                    out.printf("Result: %s%n", output);
                }
            }
            catch (Throwable t) {
                t.printStackTrace(out);
            }
            return buff.toString();
        }
    }
}

