/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.install;

import hudson.model.Computer;
import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.Os;
import org.hudsonci.plugins.vault.slave.CustomNodeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeContext
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(NodeContext.class);
    private final Map<String, String> attributes;
    private final Properties systemProperties;
    private static Map<Node, NodeContext> cache = Collections.synchronizedMap(new HashMap());

    private NodeContext(Map<String, String> attributes, Properties systemProperties) {
        assert (attributes != null);
        this.attributes = attributes;
        assert (systemProperties != null);
        this.systemProperties = systemProperties;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public String toString() {
        return "NodeContext{attributes=" + this.attributes + '}';
    }

    public static NodeContext fetch(Node node, VirtualChannel channel) throws IOException, InterruptedException {
        assert (node != null);
        assert (channel != null);
        log.debug("Fetching context for node: {} on channel: {}", (Object)node.getDisplayName(), (Object)channel);
        NodeContext context = (NodeContext)channel.call((Callable)new FetchContext());
        assert (context != null);
        for (NodeProperty prop : node.getNodeProperties()) {
            if (!(prop instanceof CustomNodeContext)) continue;
            ((CustomNodeContext)prop).applyTo(context);
        }
        return context;
    }

    public static NodeContext get(Node node, VirtualChannel channel) throws IOException, InterruptedException {
        NodeContext context = cache.get(node);
        if (context == null) {
            context = NodeContext.fetch(node, channel);
            cache.put(node, context);
        }
        return context;
    }

    public static Map<Node, NodeContext> getCache() {
        return cache;
    }

    @Named
    @Singleton
    public static class ComputerListenerImpl
    extends ComputerListener {
        public void onOffline(Computer c) {
            log.trace("Clearing caches");
            NodeContext context = NodeContext.getCache().remove(c.getNode());
            if (context != null) {
                log.trace("Removed cached context for: {}", (Object)c.getDisplayName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FetchContext
    implements Callable<NodeContext, RuntimeException> {
        private FetchContext() {
        }

        public NodeContext call() {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("os.family", Os.OS_FAMILY);
            attrs.put("os.name", Os.OS_NAME);
            attrs.put("os.arch", Os.OS_ARCH);
            attrs.put("os.version", Os.OS_VERSION);
            return new NodeContext(attrs, System.getProperties());
        }
    }
}

