/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.install;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Map;
import org.hudsonci.plugins.vault.Bundle;
import org.hudsonci.plugins.vault.Package;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.install.NodeContext;
import org.hudsonci.plugins.vault.install.PackageInstallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageSelector {
    private static final Logger log = LoggerFactory.getLogger(PackageSelector.class);
    private String bundleName;
    private NodeContext context;

    public String getBundleName() {
        if (this.bundleName == null) {
            throw new IllegalStateException("Bundle name not configured");
        }
        return this.bundleName;
    }

    public void setBundleName(String name) {
        this.bundleName = name;
    }

    public NodeContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException("Context not configured");
        }
        return this.context;
    }

    public void setContext(NodeContext context) {
        this.context = context;
    }

    public Package select() {
        String name = this.getBundleName();
        log.debug("Selecting bundle: {} with context: {}", (Object)name, (Object)this.getContext());
        Bundle bundle = Vault.get().getBundle(name);
        if (bundle == null) {
            log.warn("Unable to select package; no such bundle: {}", (Object)name);
            return null;
        }
        Package found = null;
        for (Package pkg : bundle.getPackages()) {
            if (!this.matches(pkg, this.getContext())) continue;
            found = pkg;
            break;
        }
        if (found != null) {
            log.debug("Selected: {}", found);
            if (!found.isCached()) {
                log.warn("Package cache is missing; rebuilding");
                try {
                    Vault.get().buildPackageCache(bundle, found);
                }
                catch (IOException e) {
                    throw new PackageInstallException("Failed to build package cache", e);
                }
            }
        }
        if (found == null) {
            throw new PackageInstallException(String.format("Unable to select package for bundle: %s", this.getBundleName()));
        }
        return found;
    }

    public boolean matches(Package pkg, NodeContext context) {
        assert (pkg != null);
        assert (context != null);
        Multimap<String, String> props = pkg.getProperties();
        if (props.isEmpty()) {
            return true;
        }
        Map<String, String> attrs = context.getAttributes();
        for (String key : props.keySet()) {
            String found = attrs.get(key);
            boolean matched = false;
            for (String expect : props.get((Object)key)) {
                if (!expect.equalsIgnoreCase(found)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "PackageSelector{bundleName='" + this.bundleName + '\'' + ", context=" + this.context + '}';
    }
}

