/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.slave;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Environment;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.hudsonci.plugins.vault.Bundle;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.install.NodeContext;
import org.hudsonci.plugins.vault.install.PackageInstaller;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gossip.support.DC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeOnlineInstaller
extends NodeProperty<Node> {
    private static final Logger log = LoggerFactory.getLogger(NodeOnlineInstaller.class);
    private final List<Entry> entries;

    @DataBoundConstructor
    public NodeOnlineInstaller(List<Entry> config) {
        this.entries = config;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    private void install(Computer c, Channel channel, FilePath root, TaskListener listener) throws Exception {
        assert (c != null);
        assert (channel != null);
        assert (root != null);
        assert (listener != null);
        if (this.entries == null || this.entries.isEmpty()) {
            return;
        }
        log.debug("Installing packages on: {}", (Object)c.getDisplayName());
        NodeContext context = NodeContext.get(c.getNode(), (VirtualChannel)channel);
        for (Entry entry : this.entries) {
            log.debug("Entry: {}", (Object)entry);
            PackageInstaller installer = new PackageInstaller();
            installer.setBundleName(entry.getName());
            String path = entry.getPath();
            if (path == null || path.trim().length() == 0) {
                path = entry.getName();
            }
            installer.setLocation(this.resolveLocation(context, root, path));
            installer.setNode(c.getNode());
            installer.setChannel((VirtualChannel)channel);
            installer.setListener(listener);
            try {
                installer.install();
            }
            catch (Exception e) {
                listener.error("Package installation failed: %s", new Object[]{e});
            }
        }
    }

    private FilePath resolveLocation(NodeContext context, FilePath root, String path) throws Exception {
        assert (context != null);
        assert (root != null);
        assert (path != null);
        StringSearchInterpolator interp = new StringSearchInterpolator();
        interp.addValueSource((ValueSource)new PropertiesBasedValueSource(context.getSystemProperties()));
        String location = interp.interpolate(path);
        FilePath base = root.child("vault").child("install");
        FilePath file = base.child(location);
        return file.absolutize();
    }

    public Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        NodeContext context = NodeContext.get(build.getBuiltOn(), launcher.getChannel());
        PrintStream logger = listener.getLogger();
        logger.println("Node context:");
        for (Map.Entry<String, String> attr : context.getAttributes().entrySet()) {
            logger.printf("  %s=%s", attr.getKey(), attr.getValue()).println();
        }
        return super.setUp(build, launcher, listener);
    }

    public String toString() {
        return "NodeOnlineInstaller{entries=" + this.entries + '}';
    }

    @Named
    @Singleton
    public static class ComputerListenerImpl
    extends ComputerListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
            assert (c != null);
            Node node = c.getNode();
            log.debug("Preparing to install node packages: {}", (Object)node.getDisplayName());
            DC.push((Object)node.getDisplayName());
            try {
                for (NodeProperty prop : node.getNodeProperties()) {
                    if (!(prop instanceof NodeOnlineInstaller)) continue;
                    try {
                        ((NodeOnlineInstaller)prop).install(c, channel, root, listener);
                    }
                    catch (Exception e) {
                        log.error("Installation failed", (Throwable)e);
                    }
                }
            }
            finally {
                DC.pop();
            }
        }
    }

    public static class Entry {
        private final String name;
        private final String path;

        @DataBoundConstructor
        public Entry(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return "Entry{name='" + this.name + '\'' + ", path='" + this.path + '\'' + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Named
    @Singleton
    @Typed(value={Descriptor.class})
    public static class DescriptorImpl
    extends NodePropertyDescriptor {
        public String getDisplayName() {
            return "Install from Vault";
        }

        public Collection<Bundle> getBundles() {
            return Vault.get().getBundles();
        }
    }
}

