/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.tool;

import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.hudsonci.plugins.vault.Bundle;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.install.PackageInstallListener;
import org.hudsonci.plugins.vault.install.PackageInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToolInstallerSupport
extends ToolInstaller
implements Serializable {
    protected transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final String bundleName;

    protected ToolInstallerSupport(String bundleName) {
        super(null);
        assert (bundleName != null);
        this.bundleName = bundleName;
    }

    private Object readResolve() {
        this.log = LoggerFactory.getLogger(this.getClass());
        return this;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener listener) throws IOException, InterruptedException {
        assert (listener != null);
        PackageInstaller installer = new PackageInstaller();
        installer.setBundleName(this.getBundleName());
        installer.setNode(node);
        installer.setListener(listener);
        FilePath location = this.preferredLocation(tool, node);
        installer.setLocation(location);
        if (this instanceof PackageInstallListener) {
            installer.addInstallListener((PackageInstallListener)((Object)this));
        }
        try {
            location = installer.install();
        }
        catch (Exception e) {
            listener.fatalError("Package installation failed: %s", new Object[]{e});
            e.printStackTrace(listener.getLogger());
        }
        return location;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Descriptor<T extends ToolInstallerSupport>
    extends ToolInstallerDescriptor<T> {
        private final Class<? extends ToolInstallation> toolType;
        private final String bundleType;

        protected Descriptor(Class<? extends ToolInstallation> toolType, String bundleType) {
            assert (toolType != null);
            this.toolType = toolType;
            assert (bundleType != null);
            this.bundleType = bundleType;
        }

        public String getDisplayName() {
            return "Install from Vault";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> type) {
            return this.toolType == type && !this.getBundles().isEmpty();
        }

        public Collection<Bundle> getBundles() {
            return Vault.get().findBundles(this.bundleType);
        }
    }
}

