/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.ui;

import hudson.model.Action;
import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.ui.UploadsUI;
import org.hudsonci.utils.plugin.ui.AdministratorUIComponent;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.hudsonci.utils.plugin.ui.StaplerAccessible;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadedFileUI
extends AdministratorUIComponent<UploadsUI> {
    private static final Logger log = LoggerFactory.getLogger(UploadedFileUI.class);
    private final File data;

    public UploadedFileUI(UploadsUI parent, File data) {
        super((Action)parent);
        assert (data != null);
        this.data = data;
    }

    @JellyAccessible
    public File getData() {
        return this.data;
    }

    public String getDisplayName() {
        return this.data.getName();
    }

    public String getIconFileName() {
        return this.getIconFileName("new-icon-48x48.png");
    }

    @StaplerAccessible
    public void doDelete(StaplerRequest req, StaplerResponse resp) throws Exception {
        this.checkPermission();
        this.getData().delete();
        this.redirectParent(req, resp);
    }

    @StaplerAccessible
    public void doExtract(StaplerRequest req, StaplerResponse resp, @QueryParameter(value="path", required=true, fixEmpty=true) String path) throws Exception {
        this.checkPermission();
        log.info("Extracting file: {} -> {}", (Object)this.data, (Object)path);
        Expand expand = new Expand();
        expand.setProject(new Project());
        expand.setSrc(this.data);
        File target = Vault.get().resolvePath(path);
        if (target.exists() && target.isFile()) {
            log.warn("Replacing previous content");
            target.delete();
        }
        target.mkdirs();
        expand.setDest(target);
        expand.execute();
        this.redirectParent(req, resp);
    }
}

