/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.ui;

import hudson.Util;
import hudson.model.Action;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.hudsonci.plugins.vault.Vault;
import org.hudsonci.plugins.vault.ui.UploadedFileUI;
import org.hudsonci.plugins.vault.ui.VaultUI;
import org.hudsonci.utils.plugin.ui.AdministratorUIComponent;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.hudsonci.utils.plugin.ui.StaplerAccessible;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadsUI
extends AdministratorUIComponent<VaultUI> {
    private static final Logger log = LoggerFactory.getLogger(UploadsUI.class);

    public UploadsUI(VaultUI parent) {
        super((Action)parent);
    }

    public String getDisplayName() {
        return "Uploads";
    }

    public String getIconFileName() {
        return this.getIconFileName("upload-icon-48x48.png");
    }

    @JellyAccessible
    public File[] getFiles() {
        File dir = Vault.get().getUploadsDir();
        if (dir.exists()) {
            return dir.listFiles();
        }
        return new File[0];
    }

    @StaplerAccessible
    public Object getDynamic(String name, StaplerRequest req, StaplerResponse resp) {
        assert (name != null);
        for (File file : this.getFiles()) {
            if (!name.equals(file.getName())) continue;
            return new UploadedFileUI(this, file);
        }
        return null;
    }

    @StaplerAccessible
    public void doUpload(StaplerRequest req, StaplerResponse resp) throws Exception {
        assert (req != null);
        this.checkPermission();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        FileItem fileItem = (FileItem)upload.parseRequest((HttpServletRequest)req).get(0);
        String fileName = Util.getFileName((String)fileItem.getName());
        log.info("File uploaded: {}", (Object)fileItem);
        File dir = Vault.get().getUploadsDir();
        dir.mkdirs();
        fileItem.write(new File(dir, fileName));
        fileItem.delete();
        this.redirectParent(req, resp);
    }
}

