/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.vault.util;

import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultimapUtil {
    public static void load(Multimap<String, String> map, Reader source) throws IOException {
        String line;
        assert (map != null);
        assert (source != null);
        BufferedReader reader = new BufferedReader(source);
        while ((line = reader.readLine()) != null) {
            String[] items = line.split("=", 2);
            String key = items[0].trim();
            String value = null;
            if (items.length == 2) {
                value = items[1].trim();
            }
            map.put((Object)key, value);
        }
    }

    public static void load(Multimap<String, String> map, String source) {
        assert (map != null);
        if (source == null || source.trim().length() == 0) {
            return;
        }
        try {
            MultimapUtil.load(map, new StringReader(source));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void save(Multimap<String, String> map, Writer target, String sep) throws IOException {
        assert (map != null);
        assert (target != null);
        if (map.isEmpty()) {
            return;
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(target));
        for (String key : map.keySet()) {
            for (String value : map.get((Object)key)) {
                writer.append(key).append('=').append(value).append(sep);
            }
        }
        writer.flush();
    }

    public static String save(Multimap<String, String> map, String sep) {
        assert (map != null);
        StringWriter buff = new StringWriter();
        try {
            MultimapUtil.save(map, buff, sep);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buff.toString();
    }

    public static String save(Multimap<String, String> map) {
        return MultimapUtil.save(map, "\n");
    }
}

