/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.viewVC;

import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ViewVCRepositoryBrowser
extends SubversionRepositoryBrowser {
    private static final String CHANGE_SET_FORMAT = "viewvc/?view=rev&root=%s&revision=%d";
    private static final String DIFF_FORMAT = "viewvc/%s?root=%s&r1=%d&r2=%d&diff_format=h";
    private static final String FILE_FORMAT = "viewvc/%s?root=%s&view=markup";
    public final URL url;
    private final String location;

    @DataBoundConstructor
    public ViewVCRepositoryBrowser(URL url, String location) throws MalformedURLException {
        this.url = ViewVCRepositoryBrowser.normalizeToEndWithSlash((URL)url);
        this.location = location;
    }

    public String getLocation() {
        if (this.location == null) {
            return "/";
        }
        return this.location;
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.url, String.format(DIFF_FORMAT, path.getValue(), this.getLocation(), path.getLogEntry().getRevision() - 1, path.getLogEntry().getRevision()));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.url, String.format(FILE_FORMAT, path.getValue(), this.getLocation()));
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.url, String.format(CHANGE_SET_FORMAT, this.getLocation(), changeSet.getRevision()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(ViewVCRepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "ViewVC";
        }

        public ViewVCRepositoryBrowser newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ViewVCRepositoryBrowser)((Object)req.bindParameters(ViewVCRepositoryBrowser.class, "viewVC."));
        }
    }
}

