/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.plugins.violations.util.HealthNumber;
import java.io.Serializable;

public class TypeConfig
implements Cloneable,
Serializable {
    public static final int DEFAULT_MIN = 10;
    public static final int DEFAULT_MAX = 999;
    private final String type;
    private int min = 10;
    private int max = 999;
    private String pattern = null;
    private static final long serialVersionUID = 1L;

    public TypeConfig(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.type;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void fix() {
        if (this.min < 0) {
            this.min = 0;
        }
        if (this.max <= this.min) {
            this.max = this.min + 1;
        }
    }

    public int getHealthFor(int violations) {
        if (violations < 0) {
            return -1;
        }
        return new HealthNumber(this.min, this.max).calculate(violations);
    }

    public TypeConfig clone() {
        try {
            return (TypeConfig)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

