/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.plugins.violations.TypeConfig;
import hudson.plugins.violations.TypeDescriptor;
import java.io.Serializable;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsConfig
implements Cloneable,
Serializable {
    private static final int LIMIT_DEFAULT = 100;
    private TreeMap<String, TypeConfig> typeConfigs = new TreeMap();
    private int limit = 100;
    private String sourcePathPattern;
    private String fauxProjectPath;
    private static final long serialVersionUID = 1L;

    public ViolationsConfig() {
        for (String type : TypeDescriptor.TYPES.keySet()) {
            this.typeConfigs.put(type, new TypeConfig(type));
        }
    }

    public TreeMap<String, TypeConfig> getTypeConfigs() {
        return this.typeConfigs;
    }

    public ViolationsConfig clone() {
        ViolationsConfig ret = new ViolationsConfig();
        for (String type : this.typeConfigs.keySet()) {
            if (ret.typeConfigs.get(type) == null) continue;
            ret.typeConfigs.put(type, ((TypeConfig)this.typeConfigs.get(type)).clone());
        }
        ret.limit = this.limit;
        ret.sourcePathPattern = this.sourcePathPattern;
        ret.fauxProjectPath = this.fauxProjectPath;
        return ret;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getSourcePathPattern() {
        return this.sourcePathPattern;
    }

    public void setSourcePathPattern(String sourcePathPattern) {
        this.sourcePathPattern = sourcePathPattern;
    }

    public String getFauxProjectPath() {
        return this.fauxProjectPath;
    }

    public void setFauxProjectPath(String fauxProjectPath) {
        this.fauxProjectPath = fauxProjectPath;
    }

    public void fix() {
        for (TypeConfig t : this.typeConfigs.values()) {
            t.fix();
        }
        if (this.limit <= 0) {
            this.limit = 100;
        }
    }
}

