/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsCollector;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.ViolationsProjectAction;
import hudson.plugins.violations.ViolationsPublisher;
import hudson.plugins.violations.ViolationsReport;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsPublisher
extends Publisher {
    private static final String VIOLATIONS = "violations";
    private final ViolationsConfig config = new ViolationsConfig();
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl(null);

    public ViolationsConfig getConfig() {
        return this.config;
    }

    public ViolationsConfig getOldConfig() {
        return this.config.clone();
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath htmlPath = new FilePath(new File(((Project)build.getProject()).getRootDir(), VIOLATIONS));
        FilePath targetPath = new FilePath(new File(build.getRootDir(), VIOLATIONS));
        ViolationsReport report = (ViolationsReport)((Project)build.getProject()).getWorkspace().act((FilePath.FileCallable)new ViolationsCollector(listener, targetPath, htmlPath, this.config));
        report.setConfig(this.config);
        report.setBuild(build);
        build.getActions().add(new ViolationsBuildAction(build, report));
        return true;
    }

    public Action getProjectAction(Project project) {
        return new ViolationsProjectAction(project);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

