/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.model.Build;
import hudson.model.HealthReport;
import hudson.model.Result;
import hudson.plugins.violations.TypeConfig;
import hudson.plugins.violations.TypeSummary;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.ViolationsReport;
import hudson.plugins.violations.model.BuildModel;
import hudson.plugins.violations.model.FileModel;
import hudson.plugins.violations.parse.AbstractParser;
import hudson.plugins.violations.parse.BuildModelParser;
import hudson.plugins.violations.parse.ParseXML;
import hudson.plugins.violations.render.FileModelProxy;
import hudson.plugins.violations.render.NoViolationsFile;
import hudson.plugins.violations.util.HelpHudson;
import hudson.plugins.violations.util.RecurDynamic;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsReport
implements Serializable {
    private static final Logger LOG = Logger.getLogger(ViolationsReport.class.getName());
    private Build build;
    private ViolationsConfig config;
    private Map<String, Integer> violations = new TreeMap();
    private Map<String, TypeSummary> typeSummaries = new TreeMap();
    private transient WeakReference<BuildModel> modelReference;
    private static final long serialVersionUID = 1L;

    public void setBuild(Build build) {
        this.build = build;
    }

    public Build getBuild() {
        return this.build;
    }

    public void setConfig(ViolationsConfig config) {
        this.config = config;
    }

    public ViolationsConfig getConfig() {
        return this.config;
    }

    public Map<String, Integer> getViolations() {
        return this.violations;
    }

    public HealthReport getBuildHealth() {
        List reports = this.getBuildHealths();
        HealthReport ret = null;
        for (HealthReport report : reports) {
            ret = HealthReport.min(ret, (HealthReport)report);
        }
        return ret;
    }

    public List<HealthReport> getBuildHealths() {
        ArrayList<HealthReport> ret = new ArrayList<HealthReport>();
        for (String type : this.config.getTypeConfigs().keySet()) {
            HealthReport health = this.getHealthReportFor(type);
            if (health == null) continue;
            ret.add(health);
        }
        return ret;
    }

    public HealthReport getHealthReportFor(String type) {
        Integer count = (Integer)this.violations.get(type);
        if (count == null || this.config.getTypeConfigs() == null) {
            return null;
        }
        int h = ((TypeConfig)this.config.getTypeConfigs().get(type)).getHealthFor(count.intValue());
        if (h < 0) {
            return new HealthReport(0, "No xml report files found for " + type);
        }
        return new HealthReport(h, "Number of " + type + " violations is " + count);
    }

    public BuildModel getModel() {
        BuildModel model = null;
        if (this.modelReference != null && (model = (BuildModel)this.modelReference.get()) != null) {
            return model;
        }
        File xmlFile = new File(this.build.getRootDir(), "violations/violations.xml");
        try {
            model = new BuildModel(xmlFile);
            ParseXML.parse((File)xmlFile, (AbstractParser)new BuildModelParser().buildModel(model));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Unable to parse " + xmlFile, ex);
            return null;
        }
        this.modelReference = new WeakReference<BuildModel>(model);
        return model;
    }

    public FileModelProxy getFileModelProxy(String name) {
        BuildModel model = this.getModel();
        if (model == null) {
            return null;
        }
        return (FileModelProxy)model.getFileModelMap().get(name);
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        FileModelProxy proxy;
        String name = req.getRestOfPath();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((proxy = this.getFileModelProxy(name)) != null) {
            return new RecurDynamic("", name, (Object)proxy.build(this.build).contextPath(req.getContextPath()));
        }
        return new RecurDynamic("", name, (Object)new NoViolationsFile(name, this.build));
    }

    public Map<String, TypeSummary> getTypeSummaries() {
        return this.typeSummaries;
    }

    public TypeSummary getTypeSummary(String type) {
        TypeSummary ret = (TypeSummary)this.typeSummaries.get(type);
        if (ret == null) {
            ret = new TypeSummary();
            this.typeSummaries.put(type, ret);
        }
        return ret;
    }

    public Map<String, TypeReport> getTypeReports() {
        TreeMap<String, TypeReport> ret = new TreeMap<String, TypeReport>();
        for (String t : this.violations.keySet()) {
            int c = (Integer)this.violations.get(t);
            HealthReport health = this.getHealthReportFor(t);
            ret.put(t, new TypeReport(this, t, health.getIconUrl(), c));
        }
        return ret;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        ViolationsBuildAction r;
        Build tBuild = this.build;
        int buildNumber = HelpHudson.findBuildNumber((StaplerRequest)req);
        if (buildNumber != 0 && (tBuild = (Build)this.build.getParent().getBuildByNumber(buildNumber)) == null) {
            tBuild = this.build;
        }
        if ((r = (ViolationsBuildAction)tBuild.getAction(ViolationsBuildAction.class)) == null) {
            return;
        }
        r.doGraph(req, rsp);
    }

    public ViolationsReport previous() {
        Build b = this.build;
        Build curr = (Build)b.getPreviousBuild();
        while (curr != null) {
            int number = curr.getNumber();
            if (curr.getResult() == Result.FAILURE) {
                curr = (Build)curr.getPreviousBuild();
                continue;
            }
            ViolationsBuildAction r = (ViolationsBuildAction)curr.getAction(ViolationsBuildAction.class);
            if (r != null) {
                if (r.getReport().build.getNumber() != number) {
                    System.out.println("SOMETHING is wrong!!");
                    return null;
                }
                return r.getReport();
            }
            curr = (Build)curr.getPreviousBuild();
        }
        return null;
    }

    public int typeCount(String type) {
        return ((BuildModel.TypeCount)this.getModel().getTypeCountMap().get(type)).getCount();
    }

    public int fileCount(String type) {
        return ((BuildModel.TypeCount)this.getModel().getTypeCountMap().get(type)).getNumberFiles();
    }

    public int violationCount(String type, String filename) {
        FileModelProxy proxy = this.getFileModelProxy(filename);
        if (proxy == null) {
            return 0;
        }
        FileModel fileModel = proxy.getFileModel();
        if (fileModel == null) {
            return 0;
        }
        FileModel.LimitType limit = (FileModel.LimitType)fileModel.getLimitTypeMap().get(type);
        if (limit == null) {
            return 0;
        }
        return limit.getNumber();
    }
}

