/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.graph;

import hudson.model.AbstractBuild;
import hudson.plugins.violations.TypeSummary;
import hudson.plugins.violations.ViolationsReport;
import hudson.plugins.violations.graph.SeverityTypeDataSet;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class SeverityTypeDataSet {
    private static final Color RED = new Color(239, 41, 41);
    private static final Color VIOLET = new Color(238, 130, 238);
    private static final Color YELLOW = new Color(204, 204, 0);
    private static final Color GRAY = new Color(48, 48, 48);
    private static final double INSET = 5.0;
    private static final float ALPHA = 0.8f;
    private final ViolationsReport report;
    private final String type;
    private static final Row HIGH_ROW = new Row("High", 0);
    private static final Row MEDIUM_ROW = new Row("Medium", 1);
    private static final Row LOW_ROW = new Row("Low", 2);

    public SeverityTypeDataSet(ViolationsReport report, String type) {
        this.report = report;
        this.type = type;
    }

    public CategoryDataset buildDataSet() {
        DataSetBuilder builder = new DataSetBuilder();
        for (ViolationsReport r = this.report; r != null; r = r.previous()) {
            TypeSummary t;
            if (r.getTypeSummaries() == null || (t = (TypeSummary)r.getTypeSummaries().get(this.type)) == null || t.getSeverityArray() == null || t.getSeverityArray().length != 5) continue;
            int[] nums = t.getSeverityArray();
            builder.add((Number)(nums[2] + nums[1] + nums[3]), (Comparable)MEDIUM_ROW, (Comparable)new ChartUtil.NumberOnlyBuildLabel((AbstractBuild)r.getBuild()));
            builder.add((Number)nums[0], (Comparable)HIGH_ROW, (Comparable)new ChartUtil.NumberOnlyBuildLabel((AbstractBuild)r.getBuild()));
            builder.add((Number)nums[4], (Comparable)LOW_ROW, (Comparable)new ChartUtil.NumberOnlyBuildLabel((AbstractBuild)r.getBuild()));
        }
        return builder.build();
    }

    public JFreeChart createChart() {
        CategoryDataset dataset = this.buildDataSet();
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 renderer = new StackedAreaRenderer2();
        plot.setRenderer((CategoryItemRenderer)renderer);
        renderer.setSeriesPaint(2, (Paint)RED);
        renderer.setSeriesPaint(1, (Paint)VIOLET);
        renderer.setSeriesPaint(0, (Paint)YELLOW);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

