/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.render;

import hudson.model.Build;
import hudson.plugins.violations.generate.XMLUtil;
import hudson.plugins.violations.model.FileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractParser;
import hudson.plugins.violations.parse.FileModelParser;
import hudson.plugins.violations.parse.ParseXML;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileModelProxy {
    private static final Logger LOG = Logger.getLogger(FileModelProxy.class.getName());
    private final File xmlFile;
    private FileModel fileModel;
    private String contextPath;
    private Build build;

    public FileModelProxy(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public FileModelProxy build(Build build) {
        this.build = build;
        return this;
    }

    public FileModelProxy contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public Build getBuild() {
        return this.build;
    }

    public String typeLine(String type) {
        FileModel.LimitType l = (FileModel.LimitType)this.fileModel.getLimitTypeMap().get(type);
        StringBuilder b = new StringBuilder();
        if (l == null) {
            return type + " ?number?";
        }
        b.append(type);
        b.append("&nbsp;&nbsp;&nbsp;");
        b.append(l.getNumber());
        b.append(" violation");
        if (l.getNumber() > 1) {
            b.append("s");
        }
        if (l.getSuppressed() != 0) {
            b.append(" (");
            b.append(l.getSuppressed());
            b.append(" not shown)");
        }
        return b.toString();
    }

    public boolean getShowLines() {
        return this.getFileModel().getLines().size() != 0;
    }

    private void addBlock(StringBuilder ret, StringBuilder b, int startLine, int previousLine) {
        if (b.length() == 0) {
            return;
        }
        ret.append("<tr><td colspan='3' class='source heading'>");
        ret.append("File: " + new File(this.fileModel.getDisplayName()).getName());
        ret.append(" Lines ");
        ret.append(startLine + " to " + previousLine);
        ret.append("</td></tr>\n");
        ret.append(b.toString());
        ret.append("<tr><td class='source empty' colspan='3'>&nbsp;");
        ret.append("</td></tr>\n");
    }

    public String getFileContent() {
        StringBuilder ret = new StringBuilder();
        StringBuilder b = new StringBuilder();
        ret.append("<table class='source'>\n");
        int previousLine = -1;
        int startLine = 0;
        int currentLine = -1;
        for (Map.Entry e : this.fileModel.getLines().entrySet()) {
            currentLine = (Integer)e.getKey();
            String line = (String)e.getValue();
            if (currentLine != previousLine + 1) {
                this.addBlock(ret, b, startLine, previousLine);
                b = new StringBuilder();
                startLine = currentLine;
            }
            previousLine = currentLine;
            Set v = (Set)this.fileModel.getLineViolationMap().get(currentLine);
            b.append("<tr " + (v != null ? "class='violation'" : "") + ">");
            if (v != null) {
                this.showIcon(b, v);
            } else {
                b.append("<td class='source icon'/>\n");
            }
            b.append("<td class='source line' id='line" + currentLine + "'>");
            if (v != null) {
                this.addVDiv(b);
            }
            b.append(currentLine);
            if (v != null) {
                this.showDiv(b, v);
                b.append("</div>");
            }
            b.append("</td>");
            b.append("<td class='source message'>");
            b.append(XMLUtil.escapeHTMLContent((String)(this.contextPath + "/plugin/violations/images/tab.png"), (String)line));
            b.append("</td>\n");
            b.append("</tr>\n");
        }
        this.addBlock(ret, b, startLine, previousLine);
        ret.append("</table>");
        return ret.toString();
    }

    public FileModel getFileModel() {
        if (this.fileModel != null) {
            return this.fileModel;
        }
        if (!this.xmlFile.exists()) {
            LOG.log(Level.WARNING, "The file " + this.xmlFile + " does not exist");
            return null;
        }
        try {
            FileModel t = new FileModel();
            ParseXML.parse((File)this.xmlFile, (AbstractParser)new FileModelParser().fileModel(t));
            this.fileModel = t;
            return this.fileModel;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Unable to parse " + this.xmlFile, ex);
            return null;
        }
    }

    private String getSeverityIcon(int level) {
        String color = null;
        switch (level) {
            case 0: {
                color = "red";
                break;
            }
            case 4: {
                color = "yellow";
                break;
            }
            default: {
                color = "violet";
            }
        }
        return "/plugin/violations/images/16x16/" + color + "-warning.png";
    }

    public String severityColumn(Violation v) {
        StringBuilder b = new StringBuilder();
        this.addVDiv(b);
        b.append("<a class='healthReport'>");
        b.append("<img src='" + this.contextPath + this.getSeverityIcon(v.getSeverityLevel()) + "' alt='" + v.getSeverity() + "'/>");
        b.append("</a>");
        b.append("<div class='healthReportDetails'>\n");
        b.append("<table class='violationPopup'>\n");
        b.append("<tr>\n");
        b.append("<th>Severity</th>\n");
        b.append("<td>");
        b.append(v.getSeverity());
        b.append("</td>\n");
        b.append("</tr>\n");
        b.append("<tr>\n");
        b.append("<th>Class</th>\n");
        b.append("<td>");
        b.append(v.getSource());
        b.append("</td>\n");
        b.append("</tr>\n");
        b.append("<tr>\n");
        b.append("<th>Detail</th>\n");
        b.append("<td class='message'>");
        b.append(v.getSourceDetail());
        b.append("</td>\n");
        b.append("</tr>\n");
        b.append("</table>\n");
        b.append("</div>\n");
        b.append("</div>\n");
        return b.toString();
    }

    private void addVDiv(StringBuilder b) {
        b.append("<div class='healthReport'");
        b.append("onmouseover=\"this.className='healthReport hover';return true;\"");
        b.append("onmouseout=\"this.className='healthReport';return true;\">");
    }

    private void showIcon(StringBuilder b, Set<Violation> violations) {
        int level = 4;
        for (Violation v : violations) {
            if (v.getSeverityLevel() >= level) continue;
            level = v.getSeverityLevel();
        }
        b.append("<td class='source icon'>");
        this.addVDiv(b);
        b.append("<a class='healthReport'>");
        b.append("<img src='" + this.contextPath + this.getSeverityIcon(level) + "'/>");
        b.append("</a>");
        this.showDiv(b, violations);
        b.append("</div>");
        b.append("</td>");
    }

    private void showDiv(StringBuilder b, Set<Violation> violations) {
        b.append("<div class='healthReportDetails'>\n");
        b.append(" <table class='violationPopup'>\n");
        b.append("  <thead>\n");
        b.append("   <tr>\n");
        b.append("     <th> Type</th>\n");
        b.append("     <th> Class</th>\n");
        b.append("     <th> Description</th>\n");
        b.append("   </tr>\n");
        b.append("  </thead>\n");
        b.append("  <tbody>\n");
        for (Violation v : violations) {
            b.append("   <tr>\n");
            b.append("     <td>");
            b.append(v.getType());
            b.append("</td>\n");
            b.append("     <td>");
            b.append(v.getSource());
            b.append("</td>\n");
            b.append("     <td width='100%' class='message'>");
            b.append(XMLUtil.escapeContent((String)v.getPopupMessage()));
            b.append("</td>\n");
            b.append("   </tr>\n");
        }
        b.append("  </tbody>\n");
        b.append(" </table>\n");
        b.append("</div>\n");
    }
}

