/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.cpd;

import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractTypeParser;
import hudson.plugins.violations.types.cpd.CPDParser;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CPDParser
extends AbstractTypeParser {
    private static final int LOW_LIMIT = 100;
    private static final int MEDIUM_LIMIT = 1000;

    protected void execute() throws IOException, XmlPullParserException {
        this.expectNextTag("pmd-cpd");
        this.getParser().next();
        while (this.skipToTag("duplication")) {
            this.parseDuplicationElement();
        }
    }

    private void parseDuplicationElement() throws IOException, XmlPullParserException {
        int lines = this.getInt("lines");
        int tokens = this.getInt("tokens");
        this.getParser().next();
        ArrayList<FileElement> fileElements = new ArrayList<FileElement>();
        while (this.skipToTag("file")) {
            fileElements.add(this.parseFileElement());
        }
        FileElement prev = (FileElement)fileElements.get(fileElements.size() - 1);
        for (FileElement curr : fileElements) {
            this.addViolation(lines, tokens, curr, prev);
            prev = curr;
        }
        this.endElement();
    }

    private FileElement parseFileElement() throws IOException, XmlPullParserException {
        this.expectNextTag("file");
        FileElement ret = new FileElement(this, null);
        FileElement.access$102((FileElement)ret, (int)this.getInt("line"));
        FileElement.access$202((FileElement)ret, (String)this.checkNotBlank("path").replace('\\', '/'));
        this.getParser().next();
        this.endElement();
        return ret;
    }

    private static String relativePath(String self, String other) {
        int len;
        if (self.equals(other)) {
            return "";
        }
        String[] selfParts = self.split("/");
        String[] otherParts = other.split("/");
        if (otherParts.length < (len = selfParts.length)) {
            len = otherParts.length;
        }
        for (int same = 0; same < len && selfParts[same].equals(otherParts[same]); ++same) {
        }
        StringBuilder b = new StringBuilder();
        for (int i = same + 1; i < selfParts.length; ++i) {
            b.append("../");
        }
        boolean first = true;
        for (int i = same; i < otherParts.length; ++i) {
            if (!first) {
                b.append("/");
            }
            first = false;
            b.append(otherParts[i]);
        }
        return b.toString();
    }

    private String relativePoint(FileElement self, FileElement other) {
        String path = CPDParser.relativePath((String)(FileElement.access$200((FileElement)self) + "/bats"), (String)FileElement.access$200((FileElement)other));
        return path + "#line" + FileElement.access$100((FileElement)other);
    }

    private String relativeOther(FileElement self, FileElement other) {
        StringBuilder b = new StringBuilder();
        b.append("line " + FileElement.access$100((FileElement)other));
        if (!FileElement.access$200((FileElement)self).equals(FileElement.access$200((FileElement)other))) {
            b.append(" in ");
            b.append(FileElement.access$200((FileElement)other).substring(FileElement.access$200((FileElement)other).lastIndexOf("/") + 1));
        }
        return b.toString();
    }

    private String relativeHRef(FileElement self, FileElement other) {
        StringBuilder b = new StringBuilder();
        b.append("<a href='");
        b.append(this.relativePoint(self, other));
        b.append("'>");
        b.append(this.relativeOther(self, other));
        b.append("</a>");
        return b.toString();
    }

    private void addViolation(int lines, int tokens, FileElement self, FileElement other) {
        Violation v = new Violation();
        v.setType("cpd");
        v.setLine(FileElement.access$100((FileElement)self));
        this.setSeverity(v, tokens < 100 ? "Low" : (tokens < 1000 ? "Medium" : "High"));
        v.setSource("duplication");
        v.setMessage("Duplication of " + tokens + " tokens from " + this.relativeHRef(self, other));
        v.setPopupMessage("Duplication of " + tokens + " tokens from " + this.relativeOther(self, other));
        this.getFileModel(FileElement.access$200((FileElement)self)).addViolation(v);
    }

    private void setSeverity(Violation v, String severity) {
        v.setSeverity(severity);
        v.setSeverityLevel(Severity.getSeverityLevel((String)severity));
    }
}

