/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.types.checkstyle.CheckstyleDescriptor;
import hudson.plugins.violations.types.cpd.CPDDescriptor;
import hudson.plugins.violations.types.findbugs.FindBugsDescriptor;
import hudson.plugins.violations.types.fxcop.FxCopDescriptor;
import hudson.plugins.violations.types.pmd.PMDDescriptor;
import hudson.plugins.violations.types.pylint.PyLintDescriptor;
import java.util.TreeMap;

public abstract class TypeDescriptor {
    private final String name;
    public static final TreeMap<String, TypeDescriptor> TYPES = new TreeMap();

    protected TypeDescriptor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract ViolationsParser createParser();

    public static void addDescriptor(TypeDescriptor t) {
        TYPES.put(t.getName(), t);
    }

    public String getDetailForSource(String source) {
        return null;
    }

    static {
        TypeDescriptor.addDescriptor(FindBugsDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(PMDDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(CPDDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(CheckstyleDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(PyLintDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(FxCopDescriptor.DESCRIPTOR);
    }
}

