/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Build;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.plugins.violations.ViolationsReport;
import hudson.plugins.violations.graph.SeverityTypeDataSet;
import hudson.plugins.violations.util.StringUtil;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Calendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ViolationsBuildAction
extends Actionable
implements Action,
HealthReportingAction,
StaplerProxy {
    private static final double LOG_VALUE_FOR_ZERO = 0.5;
    private boolean useLog = false;
    private static final int X_SIZE = 400;
    private static final int Y_SIZE = 200;
    private static final double PADDING = 5.0;
    private final Build owner;
    private final ViolationsReport report;

    public ViolationsBuildAction(Build owner, ViolationsReport report) {
        this.owner = owner;
        this.report = report;
    }

    public Build getBuild() {
        return this.owner;
    }

    public Object getTarget() {
        return this.getReport();
    }

    public String getDisplayName() {
        return "Violations";
    }

    public String getIconFileName() {
        return "/plugin/violations/images/24x24/dialog-warning.png";
    }

    public String getUrlName() {
        return "violations";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public ViolationsReport getReport() {
        this.report.setBuild(this.owner);
        return this.report;
    }

    public ViolationsBuildAction getPreviousResult() {
        Build b = this.owner;
        Build previous = (Build)b.getPreviousBuild();
        return ViolationsBuildAction.getViolationsAction(previous);
    }

    public HealthReport getBuildHealth() {
        return this.report.getBuildHealth();
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String type = req.getParameter("type");
        if (ChartUtil.awtProblem) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.owner.getTimestamp();
        if (!StringUtil.isBlank(type)) {
            ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)new SeverityTypeDataSet(this.getReport(), type).createChart(), (int)400, (int)200);
            return;
        }
        DataSetBuilder dsb = new DataSetBuilder();
        for (ViolationsBuildAction a = this; a != null; a = a.getPreviousResult()) {
            ViolationsReport report = a.getReport();
            report.setBuild(this.owner);
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel((AbstractBuild)a.owner);
            for (String ty : report.getViolations().keySet()) {
                dsb.add((Number)this.roundUp(report.getViolations().get(ty)), (Comparable)((Object)ty), (Comparable)label);
            }
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(dsb.build()), (int)400, (int)200);
    }

    private double roundUp(int val) {
        if (!this.useLog) {
            return 1.0 * (double)val;
        }
        if (val < 1) {
            return 0.5;
        }
        return 1.0 * (double)val;
    }

    public static ViolationsBuildAction getViolationsAction(Build start) {
        Build b = start;
        while (b != null) {
            if (b.getResult() == Result.FAILURE) {
                b = (Build)b.getPreviousBuild();
                continue;
            }
            ViolationsBuildAction r = (ViolationsBuildAction)b.getAction(ViolationsBuildAction.class);
            if (r != null) {
                return r;
            }
            b = (Build)b.getPreviousBuild();
        }
        return null;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        if (this.useLog) {
            LogarithmicAxis rangeAxis2 = new LogarithmicAxis("Log(y)");
            plot.setRangeAxis((ValueAxis)rangeAxis2);
        }
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

